/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.api.model.ProjectRequestFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ProjectRequestBuilder
extends ProjectRequestFluentImpl<ProjectRequestBuilder>
implements VisitableBuilder<ProjectRequest, ProjectRequestBuilder> {
    ProjectRequestFluent<?> fluent;

    public ProjectRequestBuilder() {
        this(new ProjectRequest());
    }

    public ProjectRequestBuilder(ProjectRequestFluent<?> fluent) {
        this(fluent, new ProjectRequest());
    }

    public ProjectRequestBuilder(ProjectRequestFluent<?> fluent, ProjectRequest instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withDescription(instance.getDescription());
        fluent.withDisplayName(instance.getDisplayName());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
    }

    public ProjectRequestBuilder(ProjectRequest instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withDescription(instance.getDescription());
        this.withDisplayName(instance.getDisplayName());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public ProjectRequest build() {
        ProjectRequest buildable = new ProjectRequest(this.fluent.getApiVersion(), this.fluent.getDescription(), this.fluent.getDisplayName(), this.fluent.getKind(), this.fluent.getMetadata());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectRequestBuilder that = (ProjectRequestBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

