/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.openshift.api.model.RoutePort;
import io.fabric8.openshift.api.model.TLSConfig;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"host", "path", "port", "tls", "to"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class RouteSpec
implements KubernetesResource {
    @JsonProperty(value="host")
    private String host;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="port")
    @Valid
    private RoutePort port;
    @JsonProperty(value="tls")
    @Valid
    private TLSConfig tls;
    @JsonProperty(value="to")
    @Valid
    private ObjectReference to;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public RouteSpec() {
    }

    public RouteSpec(String host, String path, RoutePort port, TLSConfig tls, ObjectReference to) {
        this.host = host;
        this.path = path;
        this.port = port;
        this.tls = tls;
        this.to = to;
    }

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="port")
    public RoutePort getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    public void setPort(RoutePort port) {
        this.port = port;
    }

    @JsonProperty(value="tls")
    public TLSConfig getTls() {
        return this.tls;
    }

    @JsonProperty(value="tls")
    public void setTls(TLSConfig tls) {
        this.tls = tls;
    }

    @JsonProperty(value="to")
    public ObjectReference getTo() {
        return this.to;
    }

    @JsonProperty(value="to")
    public void setTo(ObjectReference to) {
        this.to = to;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "RouteSpec(host=" + this.getHost() + ", path=" + this.getPath() + ", port=" + this.getPort() + ", tls=" + this.getTls() + ", to=" + this.getTo() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouteSpec)) {
            return false;
        }
        RouteSpec other = (RouteSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        RoutePort this$port = this.getPort();
        RoutePort other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        TLSConfig this$tls = this.getTls();
        TLSConfig other$tls = other.getTls();
        if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
            return false;
        }
        ObjectReference this$to = this.getTo();
        ObjectReference other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RouteSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 0 : $host.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 0 : $path.hashCode());
        RoutePort $port = this.getPort();
        result = result * 59 + ($port == null ? 0 : ((Object)$port).hashCode());
        TLSConfig $tls = this.getTls();
        result = result * 59 + ($tls == null ? 0 : ((Object)$tls).hashCode());
        ObjectReference $to = this.getTo();
        result = result * 59 + ($to == null ? 0 : ((Object)$to).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 0 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

