/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ScopeRestriction;
import io.fabric8.openshift.api.model.ScopeRestrictionFluent;
import io.fabric8.openshift.api.model.ScopeRestrictionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ScopeRestrictionBuilder
extends ScopeRestrictionFluentImpl<ScopeRestrictionBuilder>
implements VisitableBuilder<ScopeRestriction, ScopeRestrictionBuilder> {
    ScopeRestrictionFluent<?> fluent;

    public ScopeRestrictionBuilder() {
        this(new ScopeRestriction());
    }

    public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent) {
        this(fluent, new ScopeRestriction());
    }

    public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent, ScopeRestriction instance) {
        this.fluent = fluent;
        fluent.withClusterRole(instance.getClusterRole());
        fluent.withLiterals(instance.getLiterals());
    }

    public ScopeRestrictionBuilder(ScopeRestriction instance) {
        this.fluent = this;
        this.withClusterRole(instance.getClusterRole());
        this.withLiterals(instance.getLiterals());
    }

    @Override
    public ScopeRestriction build() {
        ScopeRestriction buildable = new ScopeRestriction(this.fluent.getClusterRole(), this.fluent.getLiterals());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScopeRestrictionBuilder that = (ScopeRestrictionBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

