/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder;

import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Visitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class BaseFluent<F extends Fluent<F>>
implements Fluent<F>,
Visitable<F> {
    public final List<Visitable> _visitables = new ArrayList<Visitable>();

    public static <T> ArrayList<T> build(List<? extends Builder<? extends T>> list) {
        ArrayList<T> result = new ArrayList<T>();
        for (Builder<T> builder : list) {
            result.add(builder.build());
        }
        return result;
    }

    public static <T> LinkedHashSet<T> build(Set<? extends Builder<? extends T>> list) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (Builder<T> builder : list) {
            result.add(builder.build());
        }
        return result;
    }

    public static <T> ArrayList<T> aggregate(List<? extends T> ... lists) {
        ArrayList<? extends T> result = new ArrayList<T>();
        for (List<? extends T> list : lists) {
            result.addAll(list);
        }
        return result;
    }

    public static <T> LinkedHashSet<T> aggregate(Set<? extends T> ... sets) {
        LinkedHashSet<? extends T> result = new LinkedHashSet<T>();
        for (Set<? extends T> set : sets) {
            result.addAll(set);
        }
        return result;
    }

    private static <V, F> Boolean canVisit(V visitor, F fluent) {
        if (visitor instanceof TypedVisitor) {
            return ((TypedVisitor)visitor).getType().isAssignableFrom(fluent.getClass());
        }
        for (Method method : visitor.getClass().getDeclaredMethods()) {
            if (method.getParameterTypes().length != 1) continue;
            Class<?> visitorType = method.getParameterTypes()[0];
            if (visitorType.isAssignableFrom(fluent.getClass())) {
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public F accept(Visitor visitor) {
        for (Visitable visitable : this._visitables) {
            visitable.accept(visitor);
        }
        if (BaseFluent.canVisit(visitor, this).booleanValue()) {
            visitor.visit(this);
        }
        return (F)this;
    }
}

