/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateRunningFluent;
import io.fabric8.kubernetes.api.model.ContainerStateRunningFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStateRunningBuilder
extends ContainerStateRunningFluentImpl<ContainerStateRunningBuilder>
implements VisitableBuilder<ContainerStateRunning, ContainerStateRunningBuilder> {
    ContainerStateRunningFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStateRunningBuilder() {
        this(true);
    }

    public ContainerStateRunningBuilder(Boolean validationEnabled) {
        this(new ContainerStateRunning(), validationEnabled);
    }

    public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerStateRunning(), validationEnabled);
    }

    public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent, ContainerStateRunning instance) {
        this(fluent, instance, true);
    }

    public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent, ContainerStateRunning instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withStartedAt(instance.getStartedAt());
        this.validationEnabled = validationEnabled;
    }

    public ContainerStateRunningBuilder(ContainerStateRunning instance) {
        this(instance, (Boolean)true);
    }

    public ContainerStateRunningBuilder(ContainerStateRunning instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withStartedAt(instance.getStartedAt());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerStateRunning build() {
        ContainerStateRunning buildable = new ContainerStateRunning(this.fluent.getStartedAt());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateRunningBuilder that = (ContainerStateRunningBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

