/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectFieldSelector;
import io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluent;
import io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ObjectFieldSelectorBuilder
extends ObjectFieldSelectorFluentImpl<ObjectFieldSelectorBuilder>
implements VisitableBuilder<ObjectFieldSelector, ObjectFieldSelectorBuilder> {
    ObjectFieldSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public ObjectFieldSelectorBuilder() {
        this(true);
    }

    public ObjectFieldSelectorBuilder(Boolean validationEnabled) {
        this(new ObjectFieldSelector(), validationEnabled);
    }

    public ObjectFieldSelectorBuilder(ObjectFieldSelectorFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ObjectFieldSelectorBuilder(ObjectFieldSelectorFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ObjectFieldSelector(), validationEnabled);
    }

    public ObjectFieldSelectorBuilder(ObjectFieldSelectorFluent<?> fluent, ObjectFieldSelector instance) {
        this(fluent, instance, true);
    }

    public ObjectFieldSelectorBuilder(ObjectFieldSelectorFluent<?> fluent, ObjectFieldSelector instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withFieldPath(instance.getFieldPath());
        this.validationEnabled = validationEnabled;
    }

    public ObjectFieldSelectorBuilder(ObjectFieldSelector instance) {
        this(instance, (Boolean)true);
    }

    public ObjectFieldSelectorBuilder(ObjectFieldSelector instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withFieldPath(instance.getFieldPath());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ObjectFieldSelector build() {
        ObjectFieldSelector buildable = new ObjectFieldSelector(this.fluent.getApiVersion(), this.fluent.getFieldPath());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectFieldSelectorBuilder that = (ObjectFieldSelectorBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

