/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilization;
import io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilizationFluent;
import io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilizationFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class CPUTargetUtilizationBuilder
extends CPUTargetUtilizationFluentImpl<CPUTargetUtilizationBuilder>
implements VisitableBuilder<CPUTargetUtilization, CPUTargetUtilizationBuilder> {
    CPUTargetUtilizationFluent<?> fluent;
    Boolean validationEnabled;

    public CPUTargetUtilizationBuilder() {
        this(true);
    }

    public CPUTargetUtilizationBuilder(Boolean validationEnabled) {
        this(new CPUTargetUtilization(), validationEnabled);
    }

    public CPUTargetUtilizationBuilder(CPUTargetUtilizationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CPUTargetUtilizationBuilder(CPUTargetUtilizationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CPUTargetUtilization(), validationEnabled);
    }

    public CPUTargetUtilizationBuilder(CPUTargetUtilizationFluent<?> fluent, CPUTargetUtilization instance) {
        this(fluent, instance, true);
    }

    public CPUTargetUtilizationBuilder(CPUTargetUtilizationFluent<?> fluent, CPUTargetUtilization instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withTargetPercentage(instance.getTargetPercentage());
        this.validationEnabled = validationEnabled;
    }

    public CPUTargetUtilizationBuilder(CPUTargetUtilization instance) {
        this(instance, (Boolean)true);
    }

    public CPUTargetUtilizationBuilder(CPUTargetUtilization instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withTargetPercentage(instance.getTargetPercentage());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CPUTargetUtilization build() {
        CPUTargetUtilization buildable = new CPUTargetUtilization(this.fluent.getTargetPercentage());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CPUTargetUtilizationBuilder that = (CPUTargetUtilizationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

