/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStatus;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStatusBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStatusFluentImpl;

public class DeploymentFluentImpl<A extends DeploymentFluent<A>>
extends BaseFluent<A>
implements DeploymentFluent<A> {
    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends DeploymentSpec, ?> spec;
    private VisitableBuilder<? extends DeploymentStatus, ?> status;

    public DeploymentFluentImpl() {
    }

    public DeploymentFluentImpl(Deployment instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public DeploymentFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DeploymentFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DeploymentFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public DeploymentSpec getSpec() {
        return this.spec != null ? (DeploymentSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(DeploymentSpec spec) {
        if (spec != null) {
            this.spec = new DeploymentSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public DeploymentFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public DeploymentFluent.SpecNested<A> withNewSpecLike(DeploymentSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public DeploymentFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public DeploymentStatus getStatus() {
        return this.status != null ? (DeploymentStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(DeploymentStatus status) {
        if (status != null) {
            this.status = new DeploymentStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public DeploymentFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public DeploymentFluent.StatusNested<A> withNewStatusLike(DeploymentStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public DeploymentFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public A withNewStatus(Integer availableReplicas, Long observedGeneration, Integer replicas, Integer unavailableReplicas, Integer updatedReplicas) {
        return this.withStatus(new DeploymentStatus(availableReplicas, observedGeneration, replicas, unavailableReplicas, updatedReplicas));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentFluentImpl that = (DeploymentFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends DeploymentStatusFluentImpl<DeploymentFluent.StatusNested<N>>
    implements DeploymentFluent.StatusNested<N>,
    Nested<N> {
        private final DeploymentStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new DeploymentStatusBuilder(this);
        }

        StatusNestedImpl(DeploymentStatus item) {
            this.builder = new DeploymentStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeploymentFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends DeploymentSpecFluentImpl<DeploymentFluent.SpecNested<N>>
    implements DeploymentFluent.SpecNested<N>,
    Nested<N> {
        private final DeploymentSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new DeploymentSpecBuilder(this);
        }

        SpecNestedImpl(DeploymentSpec item) {
            this.builder = new DeploymentSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<DeploymentFluent.MetadataNested<N>>
    implements DeploymentFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

