/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildConfigSpecBuilder
extends BuildConfigSpecFluentImpl<BuildConfigSpecBuilder>
implements VisitableBuilder<BuildConfigSpec, BuildConfigSpecBuilder> {
    BuildConfigSpecFluent<?> fluent;
    Boolean validationEnabled;

    public BuildConfigSpecBuilder() {
        this(true);
    }

    public BuildConfigSpecBuilder(Boolean validationEnabled) {
        this(new BuildConfigSpec(), validationEnabled);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildConfigSpec(), validationEnabled);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent, BuildConfigSpec instance) {
        this(fluent, instance, true);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent, BuildConfigSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        fluent.withOutput(instance.getOutput());
        fluent.withPostCommit(instance.getPostCommit());
        fluent.withResources(instance.getResources());
        fluent.withRevision(instance.getRevision());
        fluent.withRunPolicy(instance.getRunPolicy());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withSource(instance.getSource());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTriggers(instance.getTriggers());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigSpecBuilder(BuildConfigSpec instance) {
        this(instance, (Boolean)true);
    }

    public BuildConfigSpecBuilder(BuildConfigSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withRunPolicy(instance.getRunPolicy());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withTriggers(instance.getTriggers());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public BuildConfigSpec build() {
        BuildConfigSpec buildable = new BuildConfigSpec(this.fluent.getCompletionDeadlineSeconds(), this.fluent.getOutput(), this.fluent.getPostCommit(), this.fluent.getResources(), this.fluent.getRevision(), this.fluent.getRunPolicy(), this.fluent.getServiceAccount(), this.fluent.getSource(), this.fluent.getStrategy(), this.fluent.getTriggers());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigSpecBuilder that = (BuildConfigSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

