/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluent;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ClusterRoleBindingBuilder
extends ClusterRoleBindingFluentImpl<ClusterRoleBindingBuilder>
implements VisitableBuilder<ClusterRoleBinding, ClusterRoleBindingBuilder> {
    ClusterRoleBindingFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterRoleBindingBuilder() {
        this(true);
    }

    public ClusterRoleBindingBuilder(Boolean validationEnabled) {
        this(new ClusterRoleBinding(), validationEnabled);
    }

    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterRoleBinding(), validationEnabled);
    }

    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent, ClusterRoleBinding instance) {
        this(fluent, instance, true);
    }

    public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent, ClusterRoleBinding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withGroupNames(instance.getGroupNames());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRoleRef(instance.getRoleRef());
        fluent.withSubjects(instance.getSubjects());
        fluent.withUserNames(instance.getUserNames());
        this.validationEnabled = validationEnabled;
    }

    public ClusterRoleBindingBuilder(ClusterRoleBinding instance) {
        this(instance, (Boolean)true);
    }

    public ClusterRoleBindingBuilder(ClusterRoleBinding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withGroupNames(instance.getGroupNames());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.withUserNames(instance.getUserNames());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ClusterRoleBinding build() {
        ClusterRoleBinding buildable = new ClusterRoleBinding(this.fluent.getApiVersion(), this.fluent.getGroupNames(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRoleRef(), this.fluent.getSubjects(), this.fluent.getUserNames());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterRoleBindingBuilder that = (ClusterRoleBindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

