/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageStreamStatus;
import io.fabric8.openshift.api.model.ImageStreamStatusFluent;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.NamedTagEventListBuilder;
import io.fabric8.openshift.api.model.NamedTagEventListFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ImageStreamStatusFluentImpl<A extends ImageStreamStatusFluent<A>>
extends BaseFluent<A>
implements ImageStreamStatusFluent<A> {
    private String dockerImageRepository;
    private List<VisitableBuilder<? extends NamedTagEventList, ?>> tags = new ArrayList();

    public ImageStreamStatusFluentImpl() {
    }

    public ImageStreamStatusFluentImpl(ImageStreamStatus instance) {
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withTags(instance.getTags());
    }

    @Override
    public String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    @Override
    public A withDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
        return (A)this;
    }

    @Override
    public A addToTags(NamedTagEventList ... items) {
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(NamedTagEventList ... items) {
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.remove(builder);
            this.tags.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedTagEventList> getTags() {
        return ImageStreamStatusFluentImpl.build(this.tags);
    }

    @Override
    public A withTags(List<NamedTagEventList> tags) {
        this.tags.clear();
        if (tags != null) {
            for (NamedTagEventList item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTags(NamedTagEventList ... tags) {
        this.tags.clear();
        if (tags != null) {
            for (NamedTagEventList item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> addNewTag() {
        return new TagsNestedImpl();
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> addNewTagLike(NamedTagEventList item) {
        return new TagsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamStatusFluentImpl that = (ImageStreamStatusFluentImpl)o;
        if (this.dockerImageRepository != null ? !this.dockerImageRepository.equals(that.dockerImageRepository) : that.dockerImageRepository != null) {
            return false;
        }
        return !(this.tags != null ? !this.tags.equals(that.tags) : that.tags != null);
    }

    public class TagsNestedImpl<N>
    extends NamedTagEventListFluentImpl<ImageStreamStatusFluent.TagsNested<N>>
    implements ImageStreamStatusFluent.TagsNested<N>,
    Nested<N> {
        private final NamedTagEventListBuilder builder;

        TagsNestedImpl() {
            this.builder = new NamedTagEventListBuilder(this);
        }

        TagsNestedImpl(NamedTagEventList item) {
            this.builder = new NamedTagEventListBuilder(this, item);
        }

        @Override
        public N endTag() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageStreamStatusFluentImpl.this.addToTags(this.builder.build());
        }
    }
}

