package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DeprecatedDownwardAPIVolumeFileBuilder extends DeprecatedDownwardAPIVolumeFileFluentImpl<DeprecatedDownwardAPIVolumeFileBuilder> implements VisitableBuilder<DeprecatedDownwardAPIVolumeFile,DeprecatedDownwardAPIVolumeFileBuilder>{

    DeprecatedDownwardAPIVolumeFileFluent<?> fluent;
    Boolean validationEnabled;

    public DeprecatedDownwardAPIVolumeFileBuilder(){
            this(true);
    }
    public DeprecatedDownwardAPIVolumeFileBuilder(Boolean validationEnabled){
            this(new DeprecatedDownwardAPIVolumeFile(), validationEnabled);
    }
    public DeprecatedDownwardAPIVolumeFileBuilder(DeprecatedDownwardAPIVolumeFileFluent<?> fluent){
            this(fluent, true);
    }
    public DeprecatedDownwardAPIVolumeFileBuilder(DeprecatedDownwardAPIVolumeFileFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DeprecatedDownwardAPIVolumeFile(), validationEnabled);
    }
    public DeprecatedDownwardAPIVolumeFileBuilder(DeprecatedDownwardAPIVolumeFileFluent<?> fluent,DeprecatedDownwardAPIVolumeFile instance){
            this(fluent, instance, true);
    }
    public DeprecatedDownwardAPIVolumeFileBuilder(DeprecatedDownwardAPIVolumeFileFluent<?> fluent,DeprecatedDownwardAPIVolumeFile instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFieldRef(instance.getFieldRef()); 
            fluent.withMode(instance.getMode()); 
            fluent.withName(instance.getName()); 
            fluent.withResourceFieldRef(instance.getResourceFieldRef()); 
            this.validationEnabled = validationEnabled; 
    }
    public DeprecatedDownwardAPIVolumeFileBuilder(DeprecatedDownwardAPIVolumeFile instance){
            this(instance,true);
    }
    public DeprecatedDownwardAPIVolumeFileBuilder(DeprecatedDownwardAPIVolumeFile instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFieldRef(instance.getFieldRef()); 
            this.withMode(instance.getMode()); 
            this.withName(instance.getName()); 
            this.withResourceFieldRef(instance.getResourceFieldRef()); 
            this.validationEnabled = validationEnabled; 
    }

    public DeprecatedDownwardAPIVolumeFile build(){
            DeprecatedDownwardAPIVolumeFile buildable = new DeprecatedDownwardAPIVolumeFile(fluent.getFieldRef(),fluent.getMode(),fluent.getName(),fluent.getResourceFieldRef());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeprecatedDownwardAPIVolumeFileBuilder that = (DeprecatedDownwardAPIVolumeFileBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
