package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PodSpecFluent<A extends PodSpecFluent<A>> extends Fluent<A>{


    public Long getActiveDeadlineSeconds();
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
    public Boolean hasActiveDeadlineSeconds();
    public A addToContainers(int index,Container item);
    public A setToContainers(int index,Container item);
    public A addToContainers(Container... items);
    public A addAllToContainers(Collection<Container> items);
    public A removeFromContainers(Container... items);
    public A removeAllFromContainers(Collection<Container> items);
    
/**
 * This method has been deprecated, please use method buildContainers instead.
 */
@Deprecated public List<Container> getContainers();
    public List<Container> buildContainers();
    public Container buildContainer(int index);
    public Container buildFirstContainer();
    public Container buildLastContainer();
    public Container buildMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate);
    public A withContainers(List<Container> containers);
    public A withContainers(Container... containers);
    public Boolean hasContainers();
    public PodSpecFluent.ContainersNested<A> addNewContainer();
    public PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item);
    public PodSpecFluent.ContainersNested<A> setNewContainerLike(int index,Container item);
    public PodSpecFluent.ContainersNested<A> editContainer(int index);
    public PodSpecFluent.ContainersNested<A> editFirstContainer();
    public PodSpecFluent.ContainersNested<A> editLastContainer();
    public PodSpecFluent.ContainersNested<A> editMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate);
    public String getDnsPolicy();
    public A withDnsPolicy(String dnsPolicy);
    public Boolean hasDnsPolicy();
    public Boolean isHostIPC();
    public A withHostIPC(Boolean hostIPC);
    public Boolean hasHostIPC();
    public Boolean isHostNetwork();
    public A withHostNetwork(Boolean hostNetwork);
    public Boolean hasHostNetwork();
    public Boolean isHostPID();
    public A withHostPID(Boolean hostPID);
    public Boolean hasHostPID();
    public String getHostname();
    public A withHostname(String hostname);
    public Boolean hasHostname();
    public A addToImagePullSecrets(int index,LocalObjectReference item);
    public A setToImagePullSecrets(int index,LocalObjectReference item);
    public A addToImagePullSecrets(LocalObjectReference... items);
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items);
    public A removeFromImagePullSecrets(LocalObjectReference... items);
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items);
    
/**
 * This method has been deprecated, please use method buildImagePullSecrets instead.
 */
@Deprecated public List<LocalObjectReference> getImagePullSecrets();
    public List<LocalObjectReference> buildImagePullSecrets();
    public LocalObjectReference buildImagePullSecret(int index);
    public LocalObjectReference buildFirstImagePullSecret();
    public LocalObjectReference buildLastImagePullSecret();
    public LocalObjectReference buildMatchingImagePullSecret(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReferenceBuilder> predicate);
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets);
    public Boolean hasImagePullSecrets();
    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
    public PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item);
    public PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index);
    public PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
    public PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
    public PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReferenceBuilder> predicate);
    public A addNewImagePullSecret(String name);
    public String getNodeName();
    public A withNodeName(String nodeName);
    public Boolean hasNodeName();
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(Map<String,String> map);
    public Map<String,String> getNodeSelector();
    public A withNodeSelector(Map<String,String> nodeSelector);
    public Boolean hasNodeSelector();
    public String getRestartPolicy();
    public A withRestartPolicy(String restartPolicy);
    public Boolean hasRestartPolicy();
    
/**
 * This method has been deprecated, please use method buildSecurityContext instead.
 */
@Deprecated public PodSecurityContext getSecurityContext();
    public PodSecurityContext buildSecurityContext();
    public A withSecurityContext(PodSecurityContext securityContext);
    public Boolean hasSecurityContext();
    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContext();
    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(PodSecurityContext item);
    public PodSpecFluent.SecurityContextNested<A> editSecurityContext();
    public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext();
    public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(PodSecurityContext item);
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public Boolean hasServiceAccount();
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public String getSubdomain();
    public A withSubdomain(String subdomain);
    public Boolean hasSubdomain();
    public Long getTerminationGracePeriodSeconds();
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds);
    public Boolean hasTerminationGracePeriodSeconds();
    public A addToVolumes(int index,Volume item);
    public A setToVolumes(int index,Volume item);
    public A addToVolumes(Volume... items);
    public A addAllToVolumes(Collection<Volume> items);
    public A removeFromVolumes(Volume... items);
    public A removeAllFromVolumes(Collection<Volume> items);
    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 */
@Deprecated public List<Volume> getVolumes();
    public List<Volume> buildVolumes();
    public Volume buildVolume(int index);
    public Volume buildFirstVolume();
    public Volume buildLastVolume();
    public Volume buildMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VolumeBuilder> predicate);
    public A withVolumes(List<Volume> volumes);
    public A withVolumes(Volume... volumes);
    public Boolean hasVolumes();
    public PodSpecFluent.VolumesNested<A> addNewVolume();
    public PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item);
    public PodSpecFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item);
    public PodSpecFluent.VolumesNested<A> editVolume(int index);
    public PodSpecFluent.VolumesNested<A> editFirstVolume();
    public PodSpecFluent.VolumesNested<A> editLastVolume();
    public PodSpecFluent.VolumesNested<A> editMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VolumeBuilder> predicate);

    public interface ContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerFluent<PodSpecFluent.ContainersNested<N>>{

        
    public N and();    public N endContainer();
}
    public interface ImagePullSecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<PodSpecFluent.ImagePullSecretsNested<N>>{

        
    public N and();    public N endImagePullSecret();
}
    public interface SecurityContextNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodSecurityContextFluent<PodSpecFluent.SecurityContextNested<N>>{

        
    public N and();    public N endSecurityContext();
}
    public interface VolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeFluent<PodSpecFluent.VolumesNested<N>>{

        
    public N and();    public N endVolume();
}


}
