package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class ResourceQuotaSpecFluentImpl<A extends ResourceQuotaSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ResourceQuotaSpecFluent<A>{

    private Map<String,Quantity> hard = new LinkedHashMap<String,Quantity>();
    private List<String> scopes = new ArrayList<String>();

    public ResourceQuotaSpecFluentImpl(){
    }
    public ResourceQuotaSpecFluentImpl(ResourceQuotaSpec instance){
            this.withHard(instance.getHard()); 
            this.withScopes(instance.getScopes()); 
    }

    public A addToHard(String key,Quantity value){
            if(key != null && value != null) {this.hard.put(key, value);} return (A)this;
    }

    public A addToHard(Map<String,Quantity> map){
            if(map != null) { this.hard.putAll(map);} return (A)this;
    }

    public A removeFromHard(String key){
            if(key != null) {this.hard.remove(key);} return (A)this;
    }

    public A removeFromHard(Map<String,Quantity> map){
            if(map != null) { for(Object key : map.keySet()) {this.hard.remove(key);}} return (A)this;
    }

    public Map<String,Quantity> getHard(){
            return this.hard;
    }

    public A withHard(Map<String,Quantity> hard){
            this.hard.clear();
            if (hard != null) {this.hard.putAll(hard);} return (A) this;
    }

    public Boolean hasHard(){
            return this.hard!=null;
    }

    public A addToScopes(int index,String item){
            this.scopes.add(index, item); return (A)this;
    }

    public A setToScopes(int index,String item){
            this.scopes.set(index, item); return (A)this;
    }

    public A addToScopes(String... items){
            for (String item : items) {this.scopes.add(item);} return (A)this;
    }

    public A addAllToScopes(Collection<String> items){
            for (String item : items) {this.scopes.add(item);} return (A)this;
    }

    public A removeFromScopes(String... items){
            for (String item : items) {this.scopes.remove(item);} return (A)this;
    }

    public A removeAllFromScopes(Collection<String> items){
            for (String item : items) {this.scopes.remove(item);} return (A)this;
    }

    public List<String> getScopes(){
            return this.scopes;
    }

    public String getScope(int index){
            return this.scopes.get(index);
    }

    public String getFirstScope(){
            return this.scopes.get(0);
    }

    public String getLastScope(){
            return this.scopes.get(scopes.size() - 1);
    }

    public String getMatchingScope(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: scopes) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withScopes(List<String> scopes){
            this.scopes.clear();
            if (scopes != null) {for (String item : scopes){this.addToScopes(item);}} return (A) this;
    }

    public A withScopes(String... scopes){
            this.scopes.clear(); if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
    }

    public Boolean hasScopes(){
            return scopes!= null && !scopes.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceQuotaSpecFluentImpl that = (ResourceQuotaSpecFluentImpl) o;
            if (hard != null ? !hard.equals(that.hard) :that.hard != null) return false;
            if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
            return true;
    }




}
