package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class JobSpecFluentImpl<A extends JobSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JobSpecFluent<A>{

    private Long activeDeadlineSeconds;
    private Boolean autoSelector;
    private Integer completions;
    private Integer parallelism;
    private io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder selector;
    private PodTemplateSpecBuilder template;

    public JobSpecFluentImpl(){
    }
    public JobSpecFluentImpl(JobSpec instance){
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
            this.withAutoSelector(instance.getAutoSelector()); 
            this.withCompletions(instance.getCompletions()); 
            this.withParallelism(instance.getParallelism()); 
            this.withSelector(instance.getSelector()); 
            this.withTemplate(instance.getTemplate()); 
    }

    public Long getActiveDeadlineSeconds(){
            return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds){
            this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
    }

    public Boolean hasActiveDeadlineSeconds(){
            return this.activeDeadlineSeconds!=null;
    }

    public Boolean isAutoSelector(){
            return this.autoSelector;
    }

    public A withAutoSelector(Boolean autoSelector){
            this.autoSelector=autoSelector; return (A) this;
    }

    public Boolean hasAutoSelector(){
            return this.autoSelector!=null;
    }

    public Integer getCompletions(){
            return this.completions;
    }

    public A withCompletions(Integer completions){
            this.completions=completions; return (A) this;
    }

    public Boolean hasCompletions(){
            return this.completions!=null;
    }

    public Integer getParallelism(){
            return this.parallelism;
    }

    public A withParallelism(Integer parallelism){
            this.parallelism=parallelism; return (A) this;
    }

    public Boolean hasParallelism(){
            return this.parallelism!=null;
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 */
@Deprecated public io.fabric8.kubernetes.api.model.extensions.LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public io.fabric8.kubernetes.api.model.extensions.LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(io.fabric8.kubernetes.api.model.extensions.LabelSelector selector){
            _visitables.remove(this.selector);
            if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector!=null;
    }

    public JobSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public JobSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.extensions.LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public JobSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public JobSpecFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder().build());
    }

    public JobSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.extensions.LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 */
@Deprecated public PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public PodTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(PodTemplateSpec template){
            _visitables.remove(this.template);
            if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template!=null;
    }

    public JobSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public JobSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public JobSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public JobSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
    }

    public JobSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JobSpecFluentImpl that = (JobSpecFluentImpl) o;
            if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
            if (autoSelector != null ? !autoSelector.equals(that.autoSelector) :that.autoSelector != null) return false;
            if (completions != null ? !completions.equals(that.completions) :that.completions != null) return false;
            if (parallelism != null ? !parallelism.equals(that.parallelism) :that.parallelism != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluentImpl<JobSpecFluent.SelectorNested<N>> implements JobSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder builder;
    
            SelectorNestedImpl(io.fabric8.kubernetes.api.model.extensions.LabelSelector item){
                    this.builder = new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) JobSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<JobSpecFluent.TemplateNested<N>> implements JobSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(PodTemplateSpec item){
                    this.builder = new PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) JobSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
