package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface DeprecatedDownwardAPIVolumeSourceFluent<A extends DeprecatedDownwardAPIVolumeSourceFluent<A>> extends Fluent<A>{


    public Integer getDefaultMode();
    public A withDefaultMode(Integer defaultMode);
    public Boolean hasDefaultMode();
    public A addToItems(int index,DeprecatedDownwardAPIVolumeFile item);
    public A setToItems(int index,DeprecatedDownwardAPIVolumeFile item);
    public A addToItems(DeprecatedDownwardAPIVolumeFile... items);
    public A addAllToItems(Collection<DeprecatedDownwardAPIVolumeFile> items);
    public A removeFromItems(DeprecatedDownwardAPIVolumeFile... items);
    public A removeAllFromItems(Collection<DeprecatedDownwardAPIVolumeFile> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 */
@Deprecated public List<DeprecatedDownwardAPIVolumeFile> getItems();
    public List<DeprecatedDownwardAPIVolumeFile> buildItems();
    public DeprecatedDownwardAPIVolumeFile buildItem(int index);
    public DeprecatedDownwardAPIVolumeFile buildFirstItem();
    public DeprecatedDownwardAPIVolumeFile buildLastItem();
    public DeprecatedDownwardAPIVolumeFile buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<DeprecatedDownwardAPIVolumeFileBuilder> predicate);
    public A withItems(List<DeprecatedDownwardAPIVolumeFile> items);
    public A withItems(DeprecatedDownwardAPIVolumeFile... items);
    public Boolean hasItems();
    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItem();
    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItemLike(DeprecatedDownwardAPIVolumeFile item);
    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index,DeprecatedDownwardAPIVolumeFile item);
    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> editItem(int index);
    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> editFirstItem();
    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> editLastItem();
    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<DeprecatedDownwardAPIVolumeFileBuilder> predicate);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeprecatedDownwardAPIVolumeFileFluent<DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
