
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "activeDeadlineSeconds",
    "containers",
    "dnsPolicy",
    "hostIPC",
    "hostNetwork",
    "hostPID",
    "hostname",
    "imagePullSecrets",
    "nodeName",
    "nodeSelector",
    "restartPolicy",
    "securityContext",
    "serviceAccount",
    "serviceAccountName",
    "subdomain",
    "terminationGracePeriodSeconds",
    "volumes"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class PodSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("activeDeadlineSeconds")
    private Long activeDeadlineSeconds;
    /**
     * 
     * 
     */
    @JsonProperty("containers")
    @Valid
    private List<Container> containers = new ArrayList<Container>();
    /**
     * 
     * 
     */
    @JsonProperty("dnsPolicy")
    private java.lang.String dnsPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("hostIPC")
    private Boolean hostIPC;
    /**
     * 
     * 
     */
    @JsonProperty("hostNetwork")
    private Boolean hostNetwork;
    /**
     * 
     * 
     */
    @JsonProperty("hostPID")
    private Boolean hostPID;
    /**
     * 
     * 
     */
    @JsonProperty("hostname")
    private java.lang.String hostname;
    /**
     * 
     * 
     */
    @JsonProperty("imagePullSecrets")
    @Valid
    private List<LocalObjectReference> imagePullSecrets = new ArrayList<LocalObjectReference>();
    /**
     * 
     * 
     */
    @JsonProperty("nodeName")
    private java.lang.String nodeName;
    /**
     * 
     * 
     */
    @JsonProperty("nodeSelector")
    @Valid
    private Map<String, String> nodeSelector;
    /**
     * 
     * 
     */
    @JsonProperty("restartPolicy")
    private java.lang.String restartPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("securityContext")
    @Valid
    private PodSecurityContext securityContext;
    /**
     * 
     * 
     */
    @JsonProperty("serviceAccount")
    private java.lang.String serviceAccount;
    /**
     * 
     * 
     */
    @JsonProperty("serviceAccountName")
    private java.lang.String serviceAccountName;
    /**
     * 
     * 
     */
    @JsonProperty("subdomain")
    private java.lang.String subdomain;
    /**
     * 
     * 
     */
    @JsonProperty("terminationGracePeriodSeconds")
    private Long terminationGracePeriodSeconds;
    /**
     * 
     * 
     */
    @JsonProperty("volumes")
    @Valid
    private List<Volume> volumes = new ArrayList<Volume>();
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PodSpec() {
    }

    /**
     * 
     * @param dnsPolicy
     * @param nodeName
     * @param terminationGracePeriodSeconds
     * @param hostNetwork
     * @param serviceAccountName
     * @param imagePullSecrets
     * @param hostIPC
     * @param volumes
     * @param serviceAccount
     * @param securityContext
     * @param restartPolicy
     * @param nodeSelector
     * @param hostname
     * @param subdomain
     * @param containers
     * @param activeDeadlineSeconds
     * @param hostPID
     */
    public PodSpec(Long activeDeadlineSeconds, List<Container> containers, java.lang.String dnsPolicy, Boolean hostIPC, Boolean hostNetwork, Boolean hostPID, java.lang.String hostname, List<LocalObjectReference> imagePullSecrets, java.lang.String nodeName, Map<String, String> nodeSelector, java.lang.String restartPolicy, PodSecurityContext securityContext, java.lang.String serviceAccount, java.lang.String serviceAccountName, java.lang.String subdomain, Long terminationGracePeriodSeconds, List<Volume> volumes) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        this.containers = containers;
        this.dnsPolicy = dnsPolicy;
        this.hostIPC = hostIPC;
        this.hostNetwork = hostNetwork;
        this.hostPID = hostPID;
        this.hostname = hostname;
        this.imagePullSecrets = imagePullSecrets;
        this.nodeName = nodeName;
        this.nodeSelector = nodeSelector;
        this.restartPolicy = restartPolicy;
        this.securityContext = securityContext;
        this.serviceAccount = serviceAccount;
        this.serviceAccountName = serviceAccountName;
        this.subdomain = subdomain;
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        this.volumes = volumes;
    }

    /**
     * 
     * 
     * @return
     *     The activeDeadlineSeconds
     */
    @JsonProperty("activeDeadlineSeconds")
    public Long getActiveDeadlineSeconds() {
        return activeDeadlineSeconds;
    }

    /**
     * 
     * 
     * @param activeDeadlineSeconds
     *     The activeDeadlineSeconds
     */
    @JsonProperty("activeDeadlineSeconds")
    public void setActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    /**
     * 
     * 
     * @return
     *     The containers
     */
    @JsonProperty("containers")
    public List<Container> getContainers() {
        return containers;
    }

    /**
     * 
     * 
     * @param containers
     *     The containers
     */
    @JsonProperty("containers")
    public void setContainers(List<Container> containers) {
        this.containers = containers;
    }

    /**
     * 
     * 
     * @return
     *     The dnsPolicy
     */
    @JsonProperty("dnsPolicy")
    public java.lang.String getDnsPolicy() {
        return dnsPolicy;
    }

    /**
     * 
     * 
     * @param dnsPolicy
     *     The dnsPolicy
     */
    @JsonProperty("dnsPolicy")
    public void setDnsPolicy(java.lang.String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
    }

    /**
     * 
     * 
     * @return
     *     The hostIPC
     */
    @JsonProperty("hostIPC")
    public Boolean getHostIPC() {
        return hostIPC;
    }

    /**
     * 
     * 
     * @param hostIPC
     *     The hostIPC
     */
    @JsonProperty("hostIPC")
    public void setHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
    }

    /**
     * 
     * 
     * @return
     *     The hostNetwork
     */
    @JsonProperty("hostNetwork")
    public Boolean getHostNetwork() {
        return hostNetwork;
    }

    /**
     * 
     * 
     * @param hostNetwork
     *     The hostNetwork
     */
    @JsonProperty("hostNetwork")
    public void setHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    /**
     * 
     * 
     * @return
     *     The hostPID
     */
    @JsonProperty("hostPID")
    public Boolean getHostPID() {
        return hostPID;
    }

    /**
     * 
     * 
     * @param hostPID
     *     The hostPID
     */
    @JsonProperty("hostPID")
    public void setHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
    }

    /**
     * 
     * 
     * @return
     *     The hostname
     */
    @JsonProperty("hostname")
    public java.lang.String getHostname() {
        return hostname;
    }

    /**
     * 
     * 
     * @param hostname
     *     The hostname
     */
    @JsonProperty("hostname")
    public void setHostname(java.lang.String hostname) {
        this.hostname = hostname;
    }

    /**
     * 
     * 
     * @return
     *     The imagePullSecrets
     */
    @JsonProperty("imagePullSecrets")
    public List<LocalObjectReference> getImagePullSecrets() {
        return imagePullSecrets;
    }

    /**
     * 
     * 
     * @param imagePullSecrets
     *     The imagePullSecrets
     */
    @JsonProperty("imagePullSecrets")
    public void setImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    /**
     * 
     * 
     * @return
     *     The nodeName
     */
    @JsonProperty("nodeName")
    public java.lang.String getNodeName() {
        return nodeName;
    }

    /**
     * 
     * 
     * @param nodeName
     *     The nodeName
     */
    @JsonProperty("nodeName")
    public void setNodeName(java.lang.String nodeName) {
        this.nodeName = nodeName;
    }

    /**
     * 
     * 
     * @return
     *     The nodeSelector
     */
    @JsonProperty("nodeSelector")
    public Map<String, String> getNodeSelector() {
        return nodeSelector;
    }

    /**
     * 
     * 
     * @param nodeSelector
     *     The nodeSelector
     */
    @JsonProperty("nodeSelector")
    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    /**
     * 
     * 
     * @return
     *     The restartPolicy
     */
    @JsonProperty("restartPolicy")
    public java.lang.String getRestartPolicy() {
        return restartPolicy;
    }

    /**
     * 
     * 
     * @param restartPolicy
     *     The restartPolicy
     */
    @JsonProperty("restartPolicy")
    public void setRestartPolicy(java.lang.String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    /**
     * 
     * 
     * @return
     *     The securityContext
     */
    @JsonProperty("securityContext")
    public PodSecurityContext getSecurityContext() {
        return securityContext;
    }

    /**
     * 
     * 
     * @param securityContext
     *     The securityContext
     */
    @JsonProperty("securityContext")
    public void setSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccount
     */
    @JsonProperty("serviceAccount")
    public java.lang.String getServiceAccount() {
        return serviceAccount;
    }

    /**
     * 
     * 
     * @param serviceAccount
     *     The serviceAccount
     */
    @JsonProperty("serviceAccount")
    public void setServiceAccount(java.lang.String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public java.lang.String getServiceAccountName() {
        return serviceAccountName;
    }

    /**
     * 
     * 
     * @param serviceAccountName
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public void setServiceAccountName(java.lang.String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    /**
     * 
     * 
     * @return
     *     The subdomain
     */
    @JsonProperty("subdomain")
    public java.lang.String getSubdomain() {
        return subdomain;
    }

    /**
     * 
     * 
     * @param subdomain
     *     The subdomain
     */
    @JsonProperty("subdomain")
    public void setSubdomain(java.lang.String subdomain) {
        this.subdomain = subdomain;
    }

    /**
     * 
     * 
     * @return
     *     The terminationGracePeriodSeconds
     */
    @JsonProperty("terminationGracePeriodSeconds")
    public Long getTerminationGracePeriodSeconds() {
        return terminationGracePeriodSeconds;
    }

    /**
     * 
     * 
     * @param terminationGracePeriodSeconds
     *     The terminationGracePeriodSeconds
     */
    @JsonProperty("terminationGracePeriodSeconds")
    public void setTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
    }

    /**
     * 
     * 
     * @return
     *     The volumes
     */
    @JsonProperty("volumes")
    public List<Volume> getVolumes() {
        return volumes;
    }

    /**
     * 
     * 
     * @param volumes
     *     The volumes
     */
    @JsonProperty("volumes")
    public void setVolumes(List<Volume> volumes) {
        this.volumes = volumes;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
