package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CPUTargetUtilizationBuilder extends CPUTargetUtilizationFluentImpl<CPUTargetUtilizationBuilder> implements VisitableBuilder<CPUTargetUtilization,CPUTargetUtilizationBuilder>{

    CPUTargetUtilizationFluent<?> fluent;
    Boolean validationEnabled;

    public CPUTargetUtilizationBuilder(){
            this(true);
    }
    public CPUTargetUtilizationBuilder(Boolean validationEnabled){
            this(new CPUTargetUtilization(), validationEnabled);
    }
    public CPUTargetUtilizationBuilder(CPUTargetUtilizationFluent<?> fluent){
            this(fluent, true);
    }
    public CPUTargetUtilizationBuilder(CPUTargetUtilizationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CPUTargetUtilization(), validationEnabled);
    }
    public CPUTargetUtilizationBuilder(CPUTargetUtilizationFluent<?> fluent,CPUTargetUtilization instance){
            this(fluent, instance, true);
    }
    public CPUTargetUtilizationBuilder(CPUTargetUtilizationFluent<?> fluent,CPUTargetUtilization instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTargetPercentage(instance.getTargetPercentage()); 
            this.validationEnabled = validationEnabled; 
    }
    public CPUTargetUtilizationBuilder(CPUTargetUtilization instance){
            this(instance,true);
    }
    public CPUTargetUtilizationBuilder(CPUTargetUtilization instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTargetPercentage(instance.getTargetPercentage()); 
            this.validationEnabled = validationEnabled; 
    }

    public CPUTargetUtilization build(){
            CPUTargetUtilization buildable = new CPUTargetUtilization(fluent.getTargetPercentage());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CPUTargetUtilizationBuilder that = (CPUTargetUtilizationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
