package io.fabric8.kubernetes.api.model.extensions;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class PetSetStatusFluentImpl<A extends PetSetStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PetSetStatusFluent<A>{

    private Long observedGeneration;
    private Integer replicas;

    public PetSetStatusFluentImpl(){
    }
    public PetSetStatusFluentImpl(PetSetStatus instance){
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReplicas(instance.getReplicas()); 
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration!=null;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return this.replicas!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PetSetStatusFluentImpl that = (PetSetStatusFluentImpl) o;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            return true;
    }




}
