package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class NodeConditionBuilder extends NodeConditionFluent<NodeConditionBuilder> implements VisitableBuilder<NodeCondition,NodeConditionBuilder>{

     NodeConditionFluent<?> fluent;
public NodeConditionBuilder(){
    this(new NodeCondition());
}
public NodeConditionBuilder( NodeConditionFluent<?> fluent ){
    this(fluent, new NodeCondition());
}
public NodeConditionBuilder( NodeConditionFluent<?> fluent , NodeCondition instance ){
    this.fluent = fluent; fluent.withLastHeartbeatTime(instance.getLastHeartbeatTime()); fluent.withLastTransitionTime(instance.getLastTransitionTime()); fluent.withMessage(instance.getMessage()); fluent.withReason(instance.getReason()); fluent.withStatus(instance.getStatus()); fluent.withType(instance.getType()); 
}
public NodeConditionBuilder( NodeCondition instance ){
    this.fluent = this; this.withLastHeartbeatTime(instance.getLastHeartbeatTime()); this.withLastTransitionTime(instance.getLastTransitionTime()); this.withMessage(instance.getMessage()); this.withReason(instance.getReason()); this.withStatus(instance.getStatus()); this.withType(instance.getType()); 
}

public EditableNodeCondition build(){
    EditableNodeCondition buildable = new EditableNodeCondition(fluent.getLastHeartbeatTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
NodeConditionBuilder that = (NodeConditionBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    