package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class PodStatusBuilder extends PodStatusFluent<PodStatusBuilder> implements VisitableBuilder<PodStatus,PodStatusBuilder>{

     PodStatusFluent<?> fluent;
public PodStatusBuilder(){
    this(new PodStatus());
}
public PodStatusBuilder( PodStatusFluent<?> fluent ){
    this(fluent, new PodStatus());
}
public PodStatusBuilder( PodStatusFluent<?> fluent , PodStatus instance ){
    this.fluent = fluent; fluent.withConditions(instance.getConditions()); fluent.withContainerStatuses(instance.getContainerStatuses()); fluent.withHostIP(instance.getHostIP()); fluent.withMessage(instance.getMessage()); fluent.withPhase(instance.getPhase()); fluent.withPodIP(instance.getPodIP()); fluent.withReason(instance.getReason()); fluent.withStartTime(instance.getStartTime()); 
}
public PodStatusBuilder( PodStatus instance ){
    this.fluent = this; this.withConditions(instance.getConditions()); this.withContainerStatuses(instance.getContainerStatuses()); this.withHostIP(instance.getHostIP()); this.withMessage(instance.getMessage()); this.withPhase(instance.getPhase()); this.withPodIP(instance.getPodIP()); this.withReason(instance.getReason()); this.withStartTime(instance.getStartTime()); 
}

public EditablePodStatus build(){
    EditablePodStatus buildable = new EditablePodStatus(fluent.getConditions(),fluent.getContainerStatuses(),fluent.getHostIP(),fluent.getMessage(),fluent.getPhase(),fluent.getPodIP(),fluent.getReason(),fluent.getStartTime());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PodStatusBuilder that = (PodStatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    