package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;

public class DeploymentStrategyFluent<T extends DeploymentStrategyFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<CustomDeploymentStrategyParams, ?> customParams;     VisitableBuilder<RecreateDeploymentStrategyParams, ?> recreateParams;     VisitableBuilder<ResourceRequirements, ?> resources;     VisitableBuilder<RollingDeploymentStrategyParams, ?> rollingParams;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public CustomDeploymentStrategyParams getCustomParams(){
    return this.customParams!=null?this.customParams.build():null;
    }
    public T withCustomParams( CustomDeploymentStrategyParams customParams){
    if (customParams!=null){ this.customParams= new CustomDeploymentStrategyParamsBuilder(customParams); _visitables.add(this.customParams);} return (T) this;
    }
    public CustomParamsNested<T> withNewCustomParams(){
    return new CustomParamsNested<T>();
    }
    public CustomParamsNested<T> withNewCustomParamsLike( CustomDeploymentStrategyParams item){
    return new CustomParamsNested<T>(item);
    }
    public CustomParamsNested<T> editCustomParams(){
    return withNewCustomParamsLike(getCustomParams());
    }
    public RecreateDeploymentStrategyParams getRecreateParams(){
    return this.recreateParams!=null?this.recreateParams.build():null;
    }
    public T withRecreateParams( RecreateDeploymentStrategyParams recreateParams){
    if (recreateParams!=null){ this.recreateParams= new RecreateDeploymentStrategyParamsBuilder(recreateParams); _visitables.add(this.recreateParams);} return (T) this;
    }
    public RecreateParamsNested<T> withNewRecreateParams(){
    return new RecreateParamsNested<T>();
    }
    public RecreateParamsNested<T> withNewRecreateParamsLike( RecreateDeploymentStrategyParams item){
    return new RecreateParamsNested<T>(item);
    }
    public RecreateParamsNested<T> editRecreateParams(){
    return withNewRecreateParamsLike(getRecreateParams());
    }
    public ResourceRequirements getResources(){
    return this.resources!=null?this.resources.build():null;
    }
    public T withResources( ResourceRequirements resources){
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (T) this;
    }
    public ResourcesNested<T> withNewResources(){
    return new ResourcesNested<T>();
    }
    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item){
    return new ResourcesNested<T>(item);
    }
    public ResourcesNested<T> editResources(){
    return withNewResourcesLike(getResources());
    }
    public RollingDeploymentStrategyParams getRollingParams(){
    return this.rollingParams!=null?this.rollingParams.build():null;
    }
    public T withRollingParams( RollingDeploymentStrategyParams rollingParams){
    if (rollingParams!=null){ this.rollingParams= new RollingDeploymentStrategyParamsBuilder(rollingParams); _visitables.add(this.rollingParams);} return (T) this;
    }
    public RollingParamsNested<T> withNewRollingParams(){
    return new RollingParamsNested<T>();
    }
    public RollingParamsNested<T> withNewRollingParamsLike( RollingDeploymentStrategyParams item){
    return new RollingParamsNested<T>(item);
    }
    public RollingParamsNested<T> editRollingParams(){
    return withNewRollingParamsLike(getRollingParams());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentStrategyFluent that = (DeploymentStrategyFluent) o;
if (customParams != null ? !customParams.equals(that.customParams) :that.customParams != null) return false;
if (recreateParams != null ? !recreateParams.equals(that.recreateParams) :that.recreateParams != null) return false;
if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
if (rollingParams != null ? !rollingParams.equals(that.rollingParams) :that.rollingParams != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class CustomParamsNested<N> extends CustomDeploymentStrategyParamsFluent<CustomParamsNested<N>> implements Nested<N>{

        private final CustomDeploymentStrategyParamsBuilder builder;
    
             CustomParamsNested (){
        this.builder = new CustomDeploymentStrategyParamsBuilder(this);
        }
             CustomParamsNested ( CustomDeploymentStrategyParams item){
        this.builder = new CustomDeploymentStrategyParamsBuilder(this, item);
        }
    
            public N endCustomParams(){
            return and();
        }
            public N and(){
            return (N) DeploymentStrategyFluent.this.withCustomParams(builder.build());
        }
    
}
    public class RecreateParamsNested<N> extends RecreateDeploymentStrategyParamsFluent<RecreateParamsNested<N>> implements Nested<N>{

        private final RecreateDeploymentStrategyParamsBuilder builder;
    
             RecreateParamsNested (){
        this.builder = new RecreateDeploymentStrategyParamsBuilder(this);
        }
             RecreateParamsNested ( RecreateDeploymentStrategyParams item){
        this.builder = new RecreateDeploymentStrategyParamsBuilder(this, item);
        }
    
            public N endRecreateParams(){
            return and();
        }
            public N and(){
            return (N) DeploymentStrategyFluent.this.withRecreateParams(builder.build());
        }
    
}
    public class ResourcesNested<N> extends ResourceRequirementsFluent<ResourcesNested<N>> implements Nested<N>{

        private final ResourceRequirementsBuilder builder;
    
             ResourcesNested (){
        this.builder = new ResourceRequirementsBuilder(this);
        }
             ResourcesNested ( ResourceRequirements item){
        this.builder = new ResourceRequirementsBuilder(this, item);
        }
    
            public N endResources(){
            return and();
        }
            public N and(){
            return (N) DeploymentStrategyFluent.this.withResources(builder.build());
        }
    
}
    public class RollingParamsNested<N> extends RollingDeploymentStrategyParamsFluent<RollingParamsNested<N>> implements Nested<N>{

        private final RollingDeploymentStrategyParamsBuilder builder;
    
             RollingParamsNested ( RollingDeploymentStrategyParams item){
        this.builder = new RollingDeploymentStrategyParamsBuilder(this, item);
        }
             RollingParamsNested (){
        this.builder = new RollingDeploymentStrategyParamsBuilder(this);
        }
    
            public N endRollingParams(){
            return and();
        }
            public N and(){
            return (N) DeploymentStrategyFluent.this.withRollingParams(builder.build());
        }
    
}


}
