package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ClusterBuilder extends ClusterFluent<ClusterBuilder> implements VisitableBuilder<Cluster,ClusterBuilder>{

     ClusterFluent<?> fluent;
public ClusterBuilder(){
    this(new Cluster());
}
public ClusterBuilder( ClusterFluent<?> fluent ){
    this(fluent, new Cluster());
}
public ClusterBuilder( ClusterFluent<?> fluent , Cluster instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withCertificateAuthority(instance.getCertificateAuthority()); fluent.withCertificateAuthorityData(instance.getCertificateAuthorityData()); fluent.withExtensions(instance.getExtensions()); fluent.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify()); fluent.withServer(instance.getServer()); 
}
public ClusterBuilder( Cluster instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withCertificateAuthority(instance.getCertificateAuthority()); this.withCertificateAuthorityData(instance.getCertificateAuthorityData()); this.withExtensions(instance.getExtensions()); this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify()); this.withServer(instance.getServer()); 
}

public EditableCluster build(){
    EditableCluster buildable = new EditableCluster(fluent.getApiVersion(),fluent.getCertificateAuthority(),fluent.getCertificateAuthorityData(),fluent.getExtensions(),fluent.isInsecureSkipTlsVerify(),fluent.getServer());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ClusterBuilder that = (ClusterBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    