package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class HandlerFluent<T extends HandlerFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<ExecAction, ?> exec;     VisitableBuilder<HTTPGetAction, ?> httpGet;     VisitableBuilder<TCPSocketAction, ?> tcpSocket;     Map<String, Object> additionalProperties = new HashMap();

    public ExecAction getExec(){
    return this.exec!=null?this.exec.build():null;
    }
    public T withExec( ExecAction exec){
    if (exec!=null){ this.exec= new ExecActionBuilder(exec); _visitables.add(this.exec);} return (T) this;
    }
    public ExecNested<T> withNewExec(){
    return new ExecNested<T>();
    }
    public ExecNested<T> withNewExecLike( ExecAction item){
    return new ExecNested<T>(item);
    }
    public ExecNested<T> editExec(){
    return withNewExecLike(getExec());
    }
    public HTTPGetAction getHttpGet(){
    return this.httpGet!=null?this.httpGet.build():null;
    }
    public T withHttpGet( HTTPGetAction httpGet){
    if (httpGet!=null){ this.httpGet= new HTTPGetActionBuilder(httpGet); _visitables.add(this.httpGet);} return (T) this;
    }
    public HttpGetNested<T> withNewHttpGet(){
    return new HttpGetNested<T>();
    }
    public HttpGetNested<T> withNewHttpGetLike( HTTPGetAction item){
    return new HttpGetNested<T>(item);
    }
    public HttpGetNested<T> editHttpGet(){
    return withNewHttpGetLike(getHttpGet());
    }
    public TCPSocketAction getTcpSocket(){
    return this.tcpSocket!=null?this.tcpSocket.build():null;
    }
    public T withTcpSocket( TCPSocketAction tcpSocket){
    if (tcpSocket!=null){ this.tcpSocket= new TCPSocketActionBuilder(tcpSocket); _visitables.add(this.tcpSocket);} return (T) this;
    }
    public TcpSocketNested<T> withNewTcpSocket(){
    return new TcpSocketNested<T>();
    }
    public TcpSocketNested<T> withNewTcpSocketLike( TCPSocketAction item){
    return new TcpSocketNested<T>(item);
    }
    public TcpSocketNested<T> editTcpSocket(){
    return withNewTcpSocketLike(getTcpSocket());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HandlerFluent that = (HandlerFluent) o;
if (exec != null ? !exec.equals(that.exec) :that.exec != null) return false;
if (httpGet != null ? !httpGet.equals(that.httpGet) :that.httpGet != null) return false;
if (tcpSocket != null ? !tcpSocket.equals(that.tcpSocket) :that.tcpSocket != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ExecNested<N> extends ExecActionFluent<ExecNested<N>> implements Nested<N>{

        private final ExecActionBuilder builder;
    
             ExecNested (){
        this.builder = new ExecActionBuilder(this);
        }
             ExecNested ( ExecAction item){
        this.builder = new ExecActionBuilder(this, item);
        }
    
            public N endExec(){
            return and();
        }
            public N and(){
            return (N) HandlerFluent.this.withExec(builder.build());
        }
    
}
    public class HttpGetNested<N> extends HTTPGetActionFluent<HttpGetNested<N>> implements Nested<N>{

        private final HTTPGetActionBuilder builder;
    
             HttpGetNested (){
        this.builder = new HTTPGetActionBuilder(this);
        }
             HttpGetNested ( HTTPGetAction item){
        this.builder = new HTTPGetActionBuilder(this, item);
        }
    
            public N and(){
            return (N) HandlerFluent.this.withHttpGet(builder.build());
        }
            public N endHttpGet(){
            return and();
        }
    
}
    public class TcpSocketNested<N> extends TCPSocketActionFluent<TcpSocketNested<N>> implements Nested<N>{

        private final TCPSocketActionBuilder builder;
    
             TcpSocketNested (){
        this.builder = new TCPSocketActionBuilder(this);
        }
             TcpSocketNested ( TCPSocketAction item){
        this.builder = new TCPSocketActionBuilder(this, item);
        }
    
            public N endTcpSocket(){
            return and();
        }
            public N and(){
            return (N) HandlerFluent.this.withTcpSocket(builder.build());
        }
    
}


}
