package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class SELinuxContextStrategyOptionsFluent<T extends SELinuxContextStrategyOptionsFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<SELinuxOptions, ?> seLinuxOptions;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public SELinuxOptions getSeLinuxOptions(){
    return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }
    public T withSeLinuxOptions( SELinuxOptions seLinuxOptions){
    if (seLinuxOptions!=null){ this.seLinuxOptions= new SELinuxOptionsBuilder(seLinuxOptions); _visitables.add(this.seLinuxOptions);} return (T) this;
    }
    public SeLinuxOptionsNested<T> withNewSeLinuxOptions(){
    return new SeLinuxOptionsNested<T>();
    }
    public SeLinuxOptionsNested<T> withNewSeLinuxOptionsLike( SELinuxOptions item){
    return new SeLinuxOptionsNested<T>(item);
    }
    public SeLinuxOptionsNested<T> editSeLinuxOptions(){
    return withNewSeLinuxOptionsLike(getSeLinuxOptions());
    }
    public T withNewSeLinuxOptions( String level,  String role,  String type,  String user){
    return withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SELinuxContextStrategyOptionsFluent that = (SELinuxContextStrategyOptionsFluent) o;
if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class SeLinuxOptionsNested<N> extends SELinuxOptionsFluent<SeLinuxOptionsNested<N>> implements Nested<N>{

        private final SELinuxOptionsBuilder builder;
    
             SeLinuxOptionsNested (){
        this.builder = new SELinuxOptionsBuilder(this);
        }
             SeLinuxOptionsNested ( SELinuxOptions item){
        this.builder = new SELinuxOptionsBuilder(this, item);
        }
    
            public N endSeLinuxOptions(){
            return and();
        }
            public N and(){
            return (N) SELinuxContextStrategyOptionsFluent.this.withSeLinuxOptions(builder.build());
        }
    
}


}
