package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class SecretVolumeSourceBuilder extends SecretVolumeSourceFluent<SecretVolumeSourceBuilder> implements VisitableBuilder<SecretVolumeSource,SecretVolumeSourceBuilder>{

     SecretVolumeSourceFluent<?> fluent;
public SecretVolumeSourceBuilder(){
    this(new SecretVolumeSource());
}
public SecretVolumeSourceBuilder( SecretVolumeSourceFluent<?> fluent ){
    this(fluent, new SecretVolumeSource());
}
public SecretVolumeSourceBuilder( SecretVolumeSourceFluent<?> fluent , SecretVolumeSource instance ){
    this.fluent = fluent; fluent.withSecretName(instance.getSecretName()); 
}
public SecretVolumeSourceBuilder( SecretVolumeSource instance ){
    this.fluent = this; this.withSecretName(instance.getSecretName()); 
}

public EditableSecretVolumeSource build(){
    EditableSecretVolumeSource buildable = new EditableSecretVolumeSource(fluent.getSecretName());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
SecretVolumeSourceBuilder that = (SecretVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    