
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "allowHostDirVolumePlugin",
    "allowHostNetwork",
    "allowHostPorts",
    "allowPrivilegedContainer",
    "allowedCapabilities",
    "apiVersion",
    "groups",
    "kind",
    "metadata",
    "runAsUser",
    "seLinuxContext",
    "users"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class SecurityContextConstraints implements HasMetadata
{

    /**
     * allow the use of the host dir volume plugin
     * 
     */
    @JsonProperty("allowHostDirVolumePlugin")
    private Boolean allowHostDirVolumePlugin;
    /**
     * allow the use of the hostNetwork in the pod spec
     * 
     */
    @JsonProperty("allowHostNetwork")
    private Boolean allowHostNetwork;
    /**
     * allow the use of the host ports in the containers
     * 
     */
    @JsonProperty("allowHostPorts")
    private Boolean allowHostPorts;
    /**
     * allow containers to run as privileged
     * 
     */
    @JsonProperty("allowPrivilegedContainer")
    private Boolean allowPrivilegedContainer;
    /**
     * capabilities that are allowed to be added
     * 
     */
    @JsonProperty("allowedCapabilities")
    @Valid
    private List<String> allowedCapabilities = new ArrayList<String>();
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apiVersion")
    @NotNull
    private SecurityContextConstraints.ApiVersion apiVersion = SecurityContextConstraints.ApiVersion.fromValue("v1");
    /**
     * groups allowed to use this SecurityContextConstraints
     * 
     */
    @JsonProperty("groups")
    @Valid
    private List<String> groups = new ArrayList<String>();
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("kind")
    @NotNull
    private String kind = "SecurityContextConstraints";
    /**
     * 
     * 
     */
    @JsonProperty("metadata")
    @Valid
    private ObjectMeta metadata;
    /**
     * 
     * 
     */
    @JsonProperty("runAsUser")
    @Valid
    private RunAsUserStrategyOptions runAsUser;
    /**
     * 
     * 
     */
    @JsonProperty("seLinuxContext")
    @Valid
    private SELinuxContextStrategyOptions seLinuxContext;
    /**
     * users allowed to use this SecurityContextConstraints
     * 
     */
    @JsonProperty("users")
    @Valid
    private List<String> users = new ArrayList<String>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public SecurityContextConstraints() {
    }

    /**
     * 
     * @param apiVersion
     * @param users
     * @param allowPrivilegedContainer
     * @param allowHostDirVolumePlugin
     * @param seLinuxContext
     * @param runAsUser
     * @param allowedCapabilities
     * @param allowHostPorts
     * @param kind
     * @param groups
     * @param metadata
     * @param allowHostNetwork
     */
    public SecurityContextConstraints(Boolean allowHostDirVolumePlugin, Boolean allowHostNetwork, Boolean allowHostPorts, Boolean allowPrivilegedContainer, List<String> allowedCapabilities, SecurityContextConstraints.ApiVersion apiVersion, List<String> groups, String kind, ObjectMeta metadata, RunAsUserStrategyOptions runAsUser, SELinuxContextStrategyOptions seLinuxContext, List<String> users) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
        this.allowHostNetwork = allowHostNetwork;
        this.allowHostPorts = allowHostPorts;
        this.allowPrivilegedContainer = allowPrivilegedContainer;
        this.allowedCapabilities = allowedCapabilities;
        this.apiVersion = apiVersion;
        this.groups = groups;
        this.kind = kind;
        this.metadata = metadata;
        this.runAsUser = runAsUser;
        this.seLinuxContext = seLinuxContext;
        this.users = users;
    }

    /**
     * allow the use of the host dir volume plugin
     * 
     * @return
     *     The allowHostDirVolumePlugin
     */
    @JsonProperty("allowHostDirVolumePlugin")
    public Boolean getAllowHostDirVolumePlugin() {
        return allowHostDirVolumePlugin;
    }

    /**
     * allow the use of the host dir volume plugin
     * 
     * @param allowHostDirVolumePlugin
     *     The allowHostDirVolumePlugin
     */
    @JsonProperty("allowHostDirVolumePlugin")
    public void setAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
    }

    /**
     * allow the use of the hostNetwork in the pod spec
     * 
     * @return
     *     The allowHostNetwork
     */
    @JsonProperty("allowHostNetwork")
    public Boolean getAllowHostNetwork() {
        return allowHostNetwork;
    }

    /**
     * allow the use of the hostNetwork in the pod spec
     * 
     * @param allowHostNetwork
     *     The allowHostNetwork
     */
    @JsonProperty("allowHostNetwork")
    public void setAllowHostNetwork(Boolean allowHostNetwork) {
        this.allowHostNetwork = allowHostNetwork;
    }

    /**
     * allow the use of the host ports in the containers
     * 
     * @return
     *     The allowHostPorts
     */
    @JsonProperty("allowHostPorts")
    public Boolean getAllowHostPorts() {
        return allowHostPorts;
    }

    /**
     * allow the use of the host ports in the containers
     * 
     * @param allowHostPorts
     *     The allowHostPorts
     */
    @JsonProperty("allowHostPorts")
    public void setAllowHostPorts(Boolean allowHostPorts) {
        this.allowHostPorts = allowHostPorts;
    }

    /**
     * allow containers to run as privileged
     * 
     * @return
     *     The allowPrivilegedContainer
     */
    @JsonProperty("allowPrivilegedContainer")
    public Boolean getAllowPrivilegedContainer() {
        return allowPrivilegedContainer;
    }

    /**
     * allow containers to run as privileged
     * 
     * @param allowPrivilegedContainer
     *     The allowPrivilegedContainer
     */
    @JsonProperty("allowPrivilegedContainer")
    public void setAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer = allowPrivilegedContainer;
    }

    /**
     * capabilities that are allowed to be added
     * 
     * @return
     *     The allowedCapabilities
     */
    @JsonProperty("allowedCapabilities")
    public List<String> getAllowedCapabilities() {
        return allowedCapabilities;
    }

    /**
     * capabilities that are allowed to be added
     * 
     * @param allowedCapabilities
     *     The allowedCapabilities
     */
    @JsonProperty("allowedCapabilities")
    public void setAllowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities = allowedCapabilities;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public SecurityContextConstraints.ApiVersion getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(SecurityContextConstraints.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * groups allowed to use this SecurityContextConstraints
     * 
     * @return
     *     The groups
     */
    @JsonProperty("groups")
    public List<String> getGroups() {
        return groups;
    }

    /**
     * groups allowed to use this SecurityContextConstraints
     * 
     * @param groups
     *     The groups
     */
    @JsonProperty("groups")
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public String getKind() {
        return kind;
    }

    /**
     * 
     * (Required)
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    /**
     * 
     * 
     * @return
     *     The metadata
     */
    @JsonProperty("metadata")
    public ObjectMeta getMetadata() {
        return metadata;
    }

    /**
     * 
     * 
     * @param metadata
     *     The metadata
     */
    @JsonProperty("metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    /**
     * 
     * 
     * @return
     *     The runAsUser
     */
    @JsonProperty("runAsUser")
    public RunAsUserStrategyOptions getRunAsUser() {
        return runAsUser;
    }

    /**
     * 
     * 
     * @param runAsUser
     *     The runAsUser
     */
    @JsonProperty("runAsUser")
    public void setRunAsUser(RunAsUserStrategyOptions runAsUser) {
        this.runAsUser = runAsUser;
    }

    /**
     * 
     * 
     * @return
     *     The seLinuxContext
     */
    @JsonProperty("seLinuxContext")
    public SELinuxContextStrategyOptions getSeLinuxContext() {
        return seLinuxContext;
    }

    /**
     * 
     * 
     * @param seLinuxContext
     *     The seLinuxContext
     */
    @JsonProperty("seLinuxContext")
    public void setSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
        this.seLinuxContext = seLinuxContext;
    }

    /**
     * users allowed to use this SecurityContextConstraints
     * 
     * @return
     *     The users
     */
    @JsonProperty("users")
    public List<String> getUsers() {
        return users;
    }

    /**
     * users allowed to use this SecurityContextConstraints
     * 
     * @param users
     *     The users
     */
    @JsonProperty("users")
    public void setUsers(List<String> users) {
        this.users = users;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum ApiVersion {

        V_1("v1");
        private final String value;
        private static Map<String, SecurityContextConstraints.ApiVersion> constants = new HashMap<String, SecurityContextConstraints.ApiVersion>();

        static {
            for (SecurityContextConstraints.ApiVersion c: values()) {
                constants.put(c.value, c);
            }
        }

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static SecurityContextConstraints.ApiVersion fromValue(String value) {
            SecurityContextConstraints.ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
