package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class FSGroupStrategyOptionsFluentImpl<A extends FSGroupStrategyOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FSGroupStrategyOptionsFluent<A>{

    private List<IDRangeBuilder> ranges =  new ArrayList<IDRangeBuilder>();
    private String type;

    public FSGroupStrategyOptionsFluentImpl(){
    }
    public FSGroupStrategyOptionsFluentImpl(FSGroupStrategyOptions instance){
            this.withRanges(instance.getRanges()); 
            this.withType(instance.getType()); 
    }

    public A addToRanges(int index,IDRange item){
            IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ranges.add(index >= 0 ? index : ranges.size(), builder); return (A)this;
    }

    public A setToRanges(int index,IDRange item){
            IDRangeBuilder builder = new IDRangeBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ranges.size()) { ranges.add(builder); } else { ranges.set(index, builder);}
             return (A)this;
    }

    public A addToRanges(IDRange... items){
            for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.add(builder);this.ranges.add(builder);} return (A)this;
    }

    public A addAllToRanges(Collection<IDRange> items){
            for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.add(builder);this.ranges.add(builder);} return (A)this;
    }

    public A removeFromRanges(IDRange... items){
            for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.remove(builder);this.ranges.remove(builder);} return (A)this;
    }

    public A removeAllFromRanges(Collection<IDRange> items){
            for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.remove(builder);this.ranges.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRanges instead.
 */
@Deprecated public List<IDRange> getRanges(){
            return build(ranges);
    }

    public List<IDRange> buildRanges(){
            return build(ranges);
    }

    public IDRange buildRange(int index){
            return this.ranges.get(index).build();
    }

    public IDRange buildFirstRange(){
            return this.ranges.get(0).build();
    }

    public IDRange buildLastRange(){
            return this.ranges.get(ranges.size() - 1).build();
    }

    public IDRange buildMatchingRange(io.fabric8.kubernetes.api.builder.Predicate<IDRangeBuilder> predicate){
            for (IDRangeBuilder item: ranges) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withRanges(List<IDRange> ranges){
            _visitables.removeAll(this.ranges);
            this.ranges.clear();
            if (ranges != null) {for (IDRange item : ranges){this.addToRanges(item);}} return (A) this;
    }

    public A withRanges(IDRange... ranges){
            this.ranges.clear(); if (ranges != null) {for (IDRange item :ranges){ this.addToRanges(item);}} return (A) this;
    }

    public Boolean hasRanges(){
            return ranges!= null && !ranges.isEmpty();
    }

    public FSGroupStrategyOptionsFluent.RangesNested<A> addNewRange(){
            return new RangesNestedImpl();
    }

    public FSGroupStrategyOptionsFluent.RangesNested<A> addNewRangeLike(IDRange item){
            return new RangesNestedImpl(-1, item);
    }

    public FSGroupStrategyOptionsFluent.RangesNested<A> setNewRangeLike(int index,IDRange item){
            return new RangesNestedImpl(index, item);
    }

    public FSGroupStrategyOptionsFluent.RangesNested<A> editRange(int index){
            if (ranges.size() <= index) throw new RuntimeException("Can't edit ranges. Index exceeds size.");
            return setNewRangeLike(index, buildRange(index));
    }

    public FSGroupStrategyOptionsFluent.RangesNested<A> editFirstRange(){
            if (ranges.size() == 0) throw new RuntimeException("Can't edit first ranges. The list is empty.");
            return setNewRangeLike(0, buildRange(0));
    }

    public FSGroupStrategyOptionsFluent.RangesNested<A> editLastRange(){
            int index = ranges.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ranges. The list is empty.");
            return setNewRangeLike(index, buildRange(index));
    }

    public FSGroupStrategyOptionsFluent.RangesNested<A> editMatchingRange(io.fabric8.kubernetes.api.builder.Predicate<IDRangeBuilder> predicate){
            int index = -1;
            for (int i=0;i<ranges.size();i++) { 
            if (predicate.apply(ranges.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ranges. No match found.");
            return setNewRangeLike(index, buildRange(index));
    }

    public A addNewRange(Long max,Long min){
            return (A)addToRanges(new IDRange(max, min));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FSGroupStrategyOptionsFluentImpl that = (FSGroupStrategyOptionsFluentImpl) o;
            if (ranges != null ? !ranges.equals(that.ranges) :that.ranges != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class RangesNestedImpl<N> extends IDRangeFluentImpl<FSGroupStrategyOptionsFluent.RangesNested<N>> implements FSGroupStrategyOptionsFluent.RangesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IDRangeBuilder builder;
        private final int index;
    
            RangesNestedImpl(int index,IDRange item){
                    this.index = index;
                    this.builder = new IDRangeBuilder(this, item);
            }
            RangesNestedImpl(){
                    this.index = -1;
                    this.builder = new IDRangeBuilder(this);
            }
    
    public N and(){
            return (N) FSGroupStrategyOptionsFluentImpl.this.setToRanges(index, builder.build());
    }
    public N endRange(){
            return and();
    }

}


}
