package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NamedClusterRoleBuilder extends NamedClusterRoleFluentImpl<NamedClusterRoleBuilder> implements VisitableBuilder<NamedClusterRole,NamedClusterRoleBuilder>{

    NamedClusterRoleFluent<?> fluent;
    Boolean validationEnabled;

    public NamedClusterRoleBuilder(){
            this(true);
    }
    public NamedClusterRoleBuilder(Boolean validationEnabled){
            this(new NamedClusterRole(), validationEnabled);
    }
    public NamedClusterRoleBuilder(NamedClusterRoleFluent<?> fluent){
            this(fluent, true);
    }
    public NamedClusterRoleBuilder(NamedClusterRoleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NamedClusterRole(), validationEnabled);
    }
    public NamedClusterRoleBuilder(NamedClusterRoleFluent<?> fluent,NamedClusterRole instance){
            this(fluent, instance, true);
    }
    public NamedClusterRoleBuilder(NamedClusterRoleFluent<?> fluent,NamedClusterRole instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withRole(instance.getRole()); 
            this.validationEnabled = validationEnabled; 
    }
    public NamedClusterRoleBuilder(NamedClusterRole instance){
            this(instance,true);
    }
    public NamedClusterRoleBuilder(NamedClusterRole instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withRole(instance.getRole()); 
            this.validationEnabled = validationEnabled; 
    }

    public NamedClusterRole build(){
            NamedClusterRole buildable = new NamedClusterRole(fluent.getName(),fluent.getRole());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedClusterRoleBuilder that = (NamedClusterRoleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
