package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import javax.validation.Valid;
import java.lang.Object;

public class NodeFluentImpl<A extends NodeFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NodeFluent<A>{

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private NodeSpecBuilder spec;
    private NodeStatusBuilder status;

    public NodeFluentImpl(){
    }
    public NodeFluentImpl(Node instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion!=null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind!=null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata!=null;
    }

    public NodeFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public NodeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public NodeFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public NodeFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public NodeFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 */
@Deprecated public NodeSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public NodeSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(NodeSpec spec){
            _visitables.remove(this.spec);
            if (spec!=null){ this.spec= new NodeSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec!=null;
    }

    public NodeFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public NodeFluent.SpecNested<A> withNewSpecLike(NodeSpec item){
            return new SpecNestedImpl(item);
    }

    public NodeFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public NodeFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new NodeSpecBuilder().build());
    }

    public NodeFluent.SpecNested<A> editOrNewSpecLike(NodeSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 */
@Deprecated public NodeStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public NodeStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(NodeStatus status){
            _visitables.remove(this.status);
            if (status!=null){ this.status= new NodeStatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status!=null;
    }

    public NodeFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public NodeFluent.StatusNested<A> withNewStatusLike(NodeStatus item){
            return new StatusNestedImpl(item);
    }

    public NodeFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public NodeFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new NodeStatusBuilder().build());
    }

    public NodeFluent.StatusNested<A> editOrNewStatusLike(NodeStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodeFluentImpl that = (NodeFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<NodeFluent.MetadataNested<N>> implements NodeFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) NodeFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends NodeSpecFluentImpl<NodeFluent.SpecNested<N>> implements NodeFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NodeSpecBuilder builder;
    
            SpecNestedImpl(NodeSpec item){
                    this.builder = new NodeSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new NodeSpecBuilder(this);
            }
    
    public N and(){
            return (N) NodeFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends NodeStatusFluentImpl<NodeFluent.StatusNested<N>> implements NodeFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NodeStatusBuilder builder;
    
            StatusNestedImpl(NodeStatus item){
                    this.builder = new NodeStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new NodeStatusBuilder(this);
            }
    
    public N and(){
            return (N) NodeFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
