package io.fabric8.kubernetes.api.model.extensions;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class DaemonSetStatusFluentImpl<A extends DaemonSetStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DaemonSetStatusFluent<A>{

    private Long collisionCount;
    private Integer currentNumberScheduled;
    private Integer desiredNumberScheduled;
    private Integer numberAvailable;
    private Integer numberMisscheduled;
    private Integer numberReady;
    private Integer numberUnavailable;
    private Long observedGeneration;
    private Integer updatedNumberScheduled;

    public DaemonSetStatusFluentImpl(){
    }
    public DaemonSetStatusFluentImpl(DaemonSetStatus instance){
            this.withCollisionCount(instance.getCollisionCount()); 
            this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled()); 
            this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled()); 
            this.withNumberAvailable(instance.getNumberAvailable()); 
            this.withNumberMisscheduled(instance.getNumberMisscheduled()); 
            this.withNumberReady(instance.getNumberReady()); 
            this.withNumberUnavailable(instance.getNumberUnavailable()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled()); 
    }

    public Long getCollisionCount(){
            return this.collisionCount;
    }

    public A withCollisionCount(Long collisionCount){
            this.collisionCount=collisionCount; return (A) this;
    }

    public Boolean hasCollisionCount(){
            return this.collisionCount!=null;
    }

    public Integer getCurrentNumberScheduled(){
            return this.currentNumberScheduled;
    }

    public A withCurrentNumberScheduled(Integer currentNumberScheduled){
            this.currentNumberScheduled=currentNumberScheduled; return (A) this;
    }

    public Boolean hasCurrentNumberScheduled(){
            return this.currentNumberScheduled!=null;
    }

    public Integer getDesiredNumberScheduled(){
            return this.desiredNumberScheduled;
    }

    public A withDesiredNumberScheduled(Integer desiredNumberScheduled){
            this.desiredNumberScheduled=desiredNumberScheduled; return (A) this;
    }

    public Boolean hasDesiredNumberScheduled(){
            return this.desiredNumberScheduled!=null;
    }

    public Integer getNumberAvailable(){
            return this.numberAvailable;
    }

    public A withNumberAvailable(Integer numberAvailable){
            this.numberAvailable=numberAvailable; return (A) this;
    }

    public Boolean hasNumberAvailable(){
            return this.numberAvailable!=null;
    }

    public Integer getNumberMisscheduled(){
            return this.numberMisscheduled;
    }

    public A withNumberMisscheduled(Integer numberMisscheduled){
            this.numberMisscheduled=numberMisscheduled; return (A) this;
    }

    public Boolean hasNumberMisscheduled(){
            return this.numberMisscheduled!=null;
    }

    public Integer getNumberReady(){
            return this.numberReady;
    }

    public A withNumberReady(Integer numberReady){
            this.numberReady=numberReady; return (A) this;
    }

    public Boolean hasNumberReady(){
            return this.numberReady!=null;
    }

    public Integer getNumberUnavailable(){
            return this.numberUnavailable;
    }

    public A withNumberUnavailable(Integer numberUnavailable){
            this.numberUnavailable=numberUnavailable; return (A) this;
    }

    public Boolean hasNumberUnavailable(){
            return this.numberUnavailable!=null;
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration!=null;
    }

    public Integer getUpdatedNumberScheduled(){
            return this.updatedNumberScheduled;
    }

    public A withUpdatedNumberScheduled(Integer updatedNumberScheduled){
            this.updatedNumberScheduled=updatedNumberScheduled; return (A) this;
    }

    public Boolean hasUpdatedNumberScheduled(){
            return this.updatedNumberScheduled!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DaemonSetStatusFluentImpl that = (DaemonSetStatusFluentImpl) o;
            if (collisionCount != null ? !collisionCount.equals(that.collisionCount) :that.collisionCount != null) return false;
            if (currentNumberScheduled != null ? !currentNumberScheduled.equals(that.currentNumberScheduled) :that.currentNumberScheduled != null) return false;
            if (desiredNumberScheduled != null ? !desiredNumberScheduled.equals(that.desiredNumberScheduled) :that.desiredNumberScheduled != null) return false;
            if (numberAvailable != null ? !numberAvailable.equals(that.numberAvailable) :that.numberAvailable != null) return false;
            if (numberMisscheduled != null ? !numberMisscheduled.equals(that.numberMisscheduled) :that.numberMisscheduled != null) return false;
            if (numberReady != null ? !numberReady.equals(that.numberReady) :that.numberReady != null) return false;
            if (numberUnavailable != null ? !numberUnavailable.equals(that.numberUnavailable) :that.numberUnavailable != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (updatedNumberScheduled != null ? !updatedNumberScheduled.equals(that.updatedNumberScheduled) :that.updatedNumberScheduled != null) return false;
            return true;
    }




}
