/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_1;

import io.fabric8.kubernetes.api.builder.v3_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v3_1.PodSpec;
import io.fabric8.kubernetes.api.model.v3_1.PodSpecFluent;
import io.fabric8.kubernetes.api.model.v3_1.PodSpecFluentImpl;

public class PodSpecBuilder
extends PodSpecFluentImpl<PodSpecBuilder>
implements VisitableBuilder<PodSpec, PodSpecBuilder> {
    PodSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PodSpecBuilder() {
        this(true);
    }

    public PodSpecBuilder(Boolean validationEnabled) {
        this(new PodSpec(), validationEnabled);
    }

    public PodSpecBuilder(PodSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodSpecBuilder(PodSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodSpec(), validationEnabled);
    }

    public PodSpecBuilder(PodSpecFluent<?> fluent, PodSpec instance) {
        this(fluent, instance, true);
    }

    public PodSpecBuilder(PodSpecFluent<?> fluent, PodSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        fluent.withAffinity(instance.getAffinity());
        fluent.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        fluent.withContainers(instance.getContainers());
        fluent.withDnsPolicy(instance.getDnsPolicy());
        fluent.withHostAliases(instance.getHostAliases());
        fluent.withHostIPC(instance.getHostIPC());
        fluent.withHostNetwork(instance.getHostNetwork());
        fluent.withHostPID(instance.getHostPID());
        fluent.withHostname(instance.getHostname());
        fluent.withImagePullSecrets(instance.getImagePullSecrets());
        fluent.withInitContainers(instance.getInitContainers());
        fluent.withNodeName(instance.getNodeName());
        fluent.withNodeSelector(instance.getNodeSelector());
        fluent.withRestartPolicy(instance.getRestartPolicy());
        fluent.withSchedulerName(instance.getSchedulerName());
        fluent.withSecurityContext(instance.getSecurityContext());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withServiceAccountName(instance.getServiceAccountName());
        fluent.withSubdomain(instance.getSubdomain());
        fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        fluent.withTolerations(instance.getTolerations());
        fluent.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    public PodSpecBuilder(PodSpec instance) {
        this(instance, (Boolean)true);
    }

    public PodSpecBuilder(PodSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withAffinity(instance.getAffinity());
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        this.withContainers(instance.getContainers());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withHostAliases(instance.getHostAliases());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostname(instance.getHostname());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withInitContainers(instance.getInitContainers());
        this.withNodeName(instance.getNodeName());
        this.withNodeSelector(instance.getNodeSelector());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withSchedulerName(instance.getSchedulerName());
        this.withSecurityContext(instance.getSecurityContext());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withSubdomain(instance.getSubdomain());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withTolerations(instance.getTolerations());
        this.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PodSpec build() {
        PodSpec buildable = new PodSpec(this.fluent.getActiveDeadlineSeconds(), this.fluent.getAffinity(), this.fluent.isAutomountServiceAccountToken(), this.fluent.getContainers(), this.fluent.getDnsPolicy(), this.fluent.getHostAliases(), this.fluent.isHostIPC(), this.fluent.isHostNetwork(), this.fluent.isHostPID(), this.fluent.getHostname(), this.fluent.getImagePullSecrets(), this.fluent.getInitContainers(), this.fluent.getNodeName(), this.fluent.getNodeSelector(), this.fluent.getRestartPolicy(), this.fluent.getSchedulerName(), this.fluent.getSecurityContext(), this.fluent.getServiceAccount(), this.fluent.getServiceAccountName(), this.fluent.getSubdomain(), this.fluent.getTerminationGracePeriodSeconds(), this.fluent.getTolerations(), this.fluent.getVolumes());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSpecBuilder that = (PodSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

