/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_1.extensions;

import io.fabric8.kubernetes.api.builder.v3_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_1.Nested;
import io.fabric8.kubernetes.api.builder.v3_1.Predicate;
import io.fabric8.kubernetes.api.model.v3_1.ObjectMeta;
import io.fabric8.kubernetes.api.model.v3_1.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v3_1.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v3_1.extensions.APIVersion;
import io.fabric8.kubernetes.api.model.v3_1.extensions.APIVersionBuilder;
import io.fabric8.kubernetes.api.model.v3_1.extensions.APIVersionFluentImpl;
import io.fabric8.kubernetes.api.model.v3_1.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.v3_1.extensions.ThirdPartyResourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ThirdPartyResourceFluentImpl<A extends ThirdPartyResourceFluent<A>>
extends BaseFluent<A>
implements ThirdPartyResourceFluent<A> {
    private String apiVersion;
    private String description;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<APIVersionBuilder> versions = new ArrayList<APIVersionBuilder>();

    public ThirdPartyResourceFluentImpl() {
    }

    public ThirdPartyResourceFluentImpl(ThirdPartyResource instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDescription(instance.getDescription());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withVersions(instance.getVersions());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public Boolean hasDescription() {
        return this.description != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ThirdPartyResourceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ThirdPartyResourceFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ThirdPartyResourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToVersions(int index, APIVersion item) {
        APIVersionBuilder builder = new APIVersionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.versions.add(index >= 0 ? index : this.versions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVersions(int index, APIVersion item) {
        APIVersionBuilder builder = new APIVersionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.versions.size()) {
            this.versions.add(builder);
        } else {
            this.versions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVersions(APIVersion ... items) {
        for (APIVersion item : items) {
            APIVersionBuilder builder = new APIVersionBuilder(item);
            this._visitables.add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVersions(Collection<APIVersion> items) {
        for (APIVersion item : items) {
            APIVersionBuilder builder = new APIVersionBuilder(item);
            this._visitables.add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVersions(APIVersion ... items) {
        for (APIVersion item : items) {
            APIVersionBuilder builder = new APIVersionBuilder(item);
            this._visitables.remove(builder);
            this.versions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVersions(Collection<APIVersion> items) {
        for (APIVersion item : items) {
            APIVersionBuilder builder = new APIVersionBuilder(item);
            this._visitables.remove(builder);
            this.versions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<APIVersion> getVersions() {
        return ThirdPartyResourceFluentImpl.build(this.versions);
    }

    @Override
    public List<APIVersion> buildVersions() {
        return ThirdPartyResourceFluentImpl.build(this.versions);
    }

    @Override
    public APIVersion buildVersion(int index) {
        return this.versions.get(index).build();
    }

    @Override
    public APIVersion buildFirstVersion() {
        return this.versions.get(0).build();
    }

    @Override
    public APIVersion buildLastVersion() {
        return this.versions.get(this.versions.size() - 1).build();
    }

    @Override
    public APIVersion buildMatchingVersion(Predicate<APIVersionBuilder> predicate) {
        for (APIVersionBuilder item : this.versions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withVersions(List<APIVersion> versions) {
        this._visitables.removeAll(this.versions);
        this.versions.clear();
        if (versions != null) {
            for (APIVersion item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVersions(APIVersion ... versions) {
        this.versions.clear();
        if (versions != null) {
            for (APIVersion item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVersions() {
        return this.versions != null && !this.versions.isEmpty();
    }

    @Override
    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersion() {
        return new VersionsNestedImpl();
    }

    @Override
    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersionLike(APIVersion item) {
        return new VersionsNestedImpl(-1, item);
    }

    @Override
    public ThirdPartyResourceFluent.VersionsNested<A> setNewVersionLike(int index, APIVersion item) {
        return new VersionsNestedImpl(index, item);
    }

    @Override
    public ThirdPartyResourceFluent.VersionsNested<A> editVersion(int index) {
        if (this.versions.size() <= index) {
            throw new RuntimeException("Can't edit versions. Index exceeds size.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public ThirdPartyResourceFluent.VersionsNested<A> editFirstVersion() {
        if (this.versions.size() == 0) {
            throw new RuntimeException("Can't edit first versions. The list is empty.");
        }
        return this.setNewVersionLike(0, this.buildVersion(0));
    }

    @Override
    public ThirdPartyResourceFluent.VersionsNested<A> editLastVersion() {
        int index = this.versions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last versions. The list is empty.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public ThirdPartyResourceFluent.VersionsNested<A> editMatchingVersion(Predicate<APIVersionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.versions.size(); ++i) {
            if (!predicate.apply(this.versions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching versions. No match found.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public A addNewVersion(String name) {
        return this.addToVersions(new APIVersion(name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThirdPartyResourceFluentImpl that = (ThirdPartyResourceFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.versions != null ? !this.versions.equals(that.versions) : that.versions != null);
    }

    public class VersionsNestedImpl<N>
    extends APIVersionFluentImpl<ThirdPartyResourceFluent.VersionsNested<N>>
    implements ThirdPartyResourceFluent.VersionsNested<N>,
    Nested<N> {
        private final APIVersionBuilder builder;
        private final int index;

        VersionsNestedImpl(int index, APIVersion item) {
            this.index = index;
            this.builder = new APIVersionBuilder(this, item);
        }

        VersionsNestedImpl() {
            this.index = -1;
            this.builder = new APIVersionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ThirdPartyResourceFluentImpl.this.setToVersions(this.index, this.builder.build());
        }

        @Override
        public N endVersion() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ThirdPartyResourceFluent.MetadataNested<N>>
    implements ThirdPartyResourceFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ThirdPartyResourceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

