/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.builder.Function;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;

public class HasMetadataOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>>
extends BaseOperation<T, L, D, R> {
    protected HasMetadataOperation(OkHttpClient client, Config config, String apiGroup, String apiVersion, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds) {
        super(client, config, apiGroup, apiVersion, resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds);
    }

    @Override
    public D edit() throws KubernetesClientException {
        Function visitor = new Function<T, T>(){

            public T apply(T resource) {
                try {
                    if (HasMetadataOperation.this.isCascading().booleanValue() && !HasMetadataOperation.this.isReaping() && HasMetadataOperation.this.reaper != null) {
                        HasMetadataOperation.this.setReaping(true);
                        HasMetadataOperation.this.reaper.reap();
                    }
                    return HasMetadataOperation.this.replace(resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable((Throwable)e);
                }
            }
        };
        try {
            HasMetadata item = (HasMetadata)this.getMandatory();
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Function.class).newInstance(item, visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    @Override
    public T replace(T item) {
        Throwable caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                HasMetadata got;
                if (this.isCascading().booleanValue() && this.reaper != null && !this.isReaping()) {
                    this.setReaping(true);
                    this.reaper.reap();
                }
                if ((got = (HasMetadata)this.get()) == null) {
                    return null;
                }
                item.getMetadata().setResourceVersion(got.getMetadata().getResourceVersion());
                return (T)((HasMetadata)this.handleReplace(item));
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {}
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(caught);
    }
}

