/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.EditReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.openshift.client.OpenShiftConfig;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>>
extends HasMetadataOperation<T, L, D, R> {
    protected OpenShiftOperation(OkHttpClient client, OpenShiftConfig config, String apiGroup, String apiVersion, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds) {
        super(client, config, apiGroup, apiVersion, resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds);
    }

    @Override
    public URL getRootUrl() {
        try {
            return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    @Override
    public R withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        try {
            return (R)((ClientResource)this.getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class, Boolean.class, Long.TYPE).newInstance(new Object[]{this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), name, this.isCascading(), this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds()}));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    @Override
    public OpenShiftOperation<T, L, D, R> inNamespace(String namespace) {
        try {
            return (OpenShiftOperation)this.getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class, Boolean.class, Long.TYPE).newInstance(new Object[]{this.client, this.getConfig(), this.getAPIVersion(), namespace, this.getName(), this.isCascading(), this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds()});
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    @Override
    public EditReplaceDeletable<T, T, D, Boolean> cascading(boolean enabled) {
        try {
            return (ClientResource)this.getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class, Boolean.class, Long.TYPE).newInstance(new Object[]{this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), enabled, this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds()});
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    @Override
    public R load(InputStream is) {
        try {
            return (R)((ClientResource)this.getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class, Boolean.class, Long.TYPE).newInstance(new Object[]{this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), OpenShiftOperation.unmarshal(is, this.getType()), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds()}));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    @Override
    public Watchable<Watch, Watcher<T>> withResourceVersion(String resourceVersion) {
        try {
            return (Watchable)this.getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class, Boolean.class, Long.TYPE).newInstance(new Object[]{this.client, this.getConfig(), this.getAPIGroup(), this.getNamespace(), this.getName(), this.isCascading(), this.getItem(), resourceVersion, this.isReloadingFromServer(), this.getGracePeriodSeconds()});
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    @Override
    public Gettable<T> fromServer() {
        try {
            return (ClientResource)this.getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class, Boolean.class, Long.TYPE).newInstance(this.client, this.config, this.apiVersion, this.namespace, this.name, this.isCascading(), this.getItem(), this.getResourceVersion(), true, this.getGracePeriodSeconds());
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    @Override
    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }
}

