/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.servicecatalog.api.model.ServiceBinding;
import io.fabric8.servicecatalog.api.model.ServiceBindingFluent;
import io.fabric8.servicecatalog.api.model.ServiceBindingSpec;
import io.fabric8.servicecatalog.api.model.ServiceBindingSpecBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBindingSpecFluentImpl;
import io.fabric8.servicecatalog.api.model.ServiceBindingStatus;
import io.fabric8.servicecatalog.api.model.ServiceBindingStatusBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBindingStatusFluentImpl;
import java.util.Objects;

public class ServiceBindingFluentImpl<A extends ServiceBindingFluent<A>>
extends BaseFluent<A>
implements ServiceBindingFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ServiceBindingSpecBuilder spec;
    private ServiceBindingStatusBuilder status;

    public ServiceBindingFluentImpl() {
    }

    public ServiceBindingFluentImpl(ServiceBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ServiceBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ServiceBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ServiceBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ServiceBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ServiceBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ServiceBindingSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ServiceBindingSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ServiceBindingSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ServiceBindingSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ServiceBindingFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ServiceBindingFluent.SpecNested<A> withNewSpecLike(ServiceBindingSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ServiceBindingFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ServiceBindingFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ServiceBindingSpecBuilder().build());
    }

    @Override
    public ServiceBindingFluent.SpecNested<A> editOrNewSpecLike(ServiceBindingSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ServiceBindingStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ServiceBindingStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ServiceBindingStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new ServiceBindingStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ServiceBindingFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ServiceBindingFluent.StatusNested<A> withNewStatusLike(ServiceBindingStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ServiceBindingFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ServiceBindingFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ServiceBindingStatusBuilder().build());
    }

    @Override
    public ServiceBindingFluent.StatusNested<A> editOrNewStatusLike(ServiceBindingStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceBindingFluentImpl that = (ServiceBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends ServiceBindingStatusFluentImpl<ServiceBindingFluent.StatusNested<N>>
    implements ServiceBindingFluent.StatusNested<N>,
    Nested<N> {
        ServiceBindingStatusBuilder builder;

        StatusNestedImpl(ServiceBindingStatus item) {
            this.builder = new ServiceBindingStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ServiceBindingStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ServiceBindingSpecFluentImpl<ServiceBindingFluent.SpecNested<N>>
    implements ServiceBindingFluent.SpecNested<N>,
    Nested<N> {
        ServiceBindingSpecBuilder builder;

        SpecNestedImpl(ServiceBindingSpec item) {
            this.builder = new ServiceBindingSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ServiceBindingSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ServiceBindingFluent.MetadataNested<N>>
    implements ServiceBindingFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

