/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.tekton.pipeline.v1beta1.PipelineResourceRef;
import io.fabric8.tekton.pipeline.v1beta1.PipelineResourceRefBuilder;
import io.fabric8.tekton.pipeline.v1beta1.PipelineResourceRefFluentImpl;
import io.fabric8.tekton.pipeline.v1beta1.TaskResourceBinding;
import io.fabric8.tekton.pipeline.v1beta1.TaskResourceBindingFluent;
import io.fabric8.tekton.v1beta1.internal.pipeline.pkg.apis.resource.v1alpha1.PipelineResourceSpec;
import io.fabric8.tekton.v1beta1.internal.pipeline.pkg.apis.resource.v1alpha1.PipelineResourceSpecBuilder;
import io.fabric8.tekton.v1beta1.internal.pipeline.pkg.apis.resource.v1alpha1.PipelineResourceSpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TaskResourceBindingFluentImpl<A extends TaskResourceBindingFluent<A>>
extends BaseFluent<A>
implements TaskResourceBindingFluent<A> {
    private String name;
    private List<String> paths;
    private PipelineResourceRefBuilder resourceRef;
    private PipelineResourceSpecBuilder resourceSpec;

    public TaskResourceBindingFluentImpl() {
    }

    public TaskResourceBindingFluentImpl(TaskResourceBinding instance) {
        this.withName(instance.getName());
        this.withPaths(instance.getPaths());
        this.withResourceRef(instance.getResourceRef());
        this.withResourceSpec(instance.getResourceSpec());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A addToPaths(int index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPaths(int index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPaths(String ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPaths(Collection<String> items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(String ... items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPaths(Collection<String> items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public String getPath(int index) {
        return this.paths.get(index);
    }

    @Override
    public String getFirstPath() {
        return this.paths.get(0);
    }

    @Override
    public String getLastPath() {
        return this.paths.get(this.paths.size() - 1);
    }

    @Override
    public String getMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPaths(List<String> paths) {
        if (this.paths != null) {
            this._visitables.get((Object)"paths").removeAll(this.paths);
        }
        if (paths != null) {
            this.paths = new ArrayList<String>();
            for (String item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)this;
    }

    @Override
    public A withPaths(String ... paths) {
        if (this.paths != null) {
            this.paths.clear();
        }
        if (paths != null) {
            for (String item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public A addNewPath(String arg1) {
        return this.addToPaths(new String(arg1));
    }

    @Override
    public A addNewPath(StringBuilder arg1) {
        return this.addToPaths(new String(arg1));
    }

    @Override
    public A addNewPath(StringBuffer arg1) {
        return this.addToPaths(new String(arg1));
    }

    @Override
    @Deprecated
    public PipelineResourceRef getResourceRef() {
        return this.resourceRef != null ? this.resourceRef.build() : null;
    }

    @Override
    public PipelineResourceRef buildResourceRef() {
        return this.resourceRef != null ? this.resourceRef.build() : null;
    }

    @Override
    public A withResourceRef(PipelineResourceRef resourceRef) {
        this._visitables.get((Object)"resourceRef").remove(this.resourceRef);
        if (resourceRef != null) {
            this.resourceRef = new PipelineResourceRefBuilder(resourceRef);
            this._visitables.get((Object)"resourceRef").add(this.resourceRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceRef() {
        return this.resourceRef != null;
    }

    @Override
    public A withNewResourceRef(String apiVersion, String name) {
        return this.withResourceRef(new PipelineResourceRef(apiVersion, name));
    }

    @Override
    public TaskResourceBindingFluent.ResourceRefNested<A> withNewResourceRef() {
        return new ResourceRefNestedImpl();
    }

    @Override
    public TaskResourceBindingFluent.ResourceRefNested<A> withNewResourceRefLike(PipelineResourceRef item) {
        return new ResourceRefNestedImpl(item);
    }

    @Override
    public TaskResourceBindingFluent.ResourceRefNested<A> editResourceRef() {
        return this.withNewResourceRefLike(this.getResourceRef());
    }

    @Override
    public TaskResourceBindingFluent.ResourceRefNested<A> editOrNewResourceRef() {
        return this.withNewResourceRefLike(this.getResourceRef() != null ? this.getResourceRef() : new PipelineResourceRefBuilder().build());
    }

    @Override
    public TaskResourceBindingFluent.ResourceRefNested<A> editOrNewResourceRefLike(PipelineResourceRef item) {
        return this.withNewResourceRefLike(this.getResourceRef() != null ? this.getResourceRef() : item);
    }

    @Override
    @Deprecated
    public PipelineResourceSpec getResourceSpec() {
        return this.resourceSpec != null ? this.resourceSpec.build() : null;
    }

    @Override
    public PipelineResourceSpec buildResourceSpec() {
        return this.resourceSpec != null ? this.resourceSpec.build() : null;
    }

    @Override
    public A withResourceSpec(PipelineResourceSpec resourceSpec) {
        this._visitables.get((Object)"resourceSpec").remove(this.resourceSpec);
        if (resourceSpec != null) {
            this.resourceSpec = new PipelineResourceSpecBuilder(resourceSpec);
            this._visitables.get((Object)"resourceSpec").add(this.resourceSpec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceSpec() {
        return this.resourceSpec != null;
    }

    @Override
    public TaskResourceBindingFluent.ResourceSpecNested<A> withNewResourceSpec() {
        return new ResourceSpecNestedImpl();
    }

    @Override
    public TaskResourceBindingFluent.ResourceSpecNested<A> withNewResourceSpecLike(PipelineResourceSpec item) {
        return new ResourceSpecNestedImpl(item);
    }

    @Override
    public TaskResourceBindingFluent.ResourceSpecNested<A> editResourceSpec() {
        return this.withNewResourceSpecLike(this.getResourceSpec());
    }

    @Override
    public TaskResourceBindingFluent.ResourceSpecNested<A> editOrNewResourceSpec() {
        return this.withNewResourceSpecLike(this.getResourceSpec() != null ? this.getResourceSpec() : new PipelineResourceSpecBuilder().build());
    }

    @Override
    public TaskResourceBindingFluent.ResourceSpecNested<A> editOrNewResourceSpecLike(PipelineResourceSpec item) {
        return this.withNewResourceSpecLike(this.getResourceSpec() != null ? this.getResourceSpec() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskResourceBindingFluentImpl that = (TaskResourceBindingFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) {
            return false;
        }
        if (this.resourceRef != null ? !this.resourceRef.equals(that.resourceRef) : that.resourceRef != null) {
            return false;
        }
        return !(this.resourceSpec != null ? !this.resourceSpec.equals(that.resourceSpec) : that.resourceSpec != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.paths, this.resourceRef, this.resourceSpec, super.hashCode());
    }

    public class ResourceSpecNestedImpl<N>
    extends PipelineResourceSpecFluentImpl<TaskResourceBindingFluent.ResourceSpecNested<N>>
    implements TaskResourceBindingFluent.ResourceSpecNested<N>,
    Nested<N> {
        private final PipelineResourceSpecBuilder builder;

        ResourceSpecNestedImpl(PipelineResourceSpec item) {
            this.builder = new PipelineResourceSpecBuilder(this, item);
        }

        ResourceSpecNestedImpl() {
            this.builder = new PipelineResourceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskResourceBindingFluentImpl.this.withResourceSpec(this.builder.build());
        }

        @Override
        public N endResourceSpec() {
            return this.and();
        }
    }

    public class ResourceRefNestedImpl<N>
    extends PipelineResourceRefFluentImpl<TaskResourceBindingFluent.ResourceRefNested<N>>
    implements TaskResourceBindingFluent.ResourceRefNested<N>,
    Nested<N> {
        private final PipelineResourceRefBuilder builder;

        ResourceRefNestedImpl(PipelineResourceRef item) {
            this.builder = new PipelineResourceRefBuilder(this, item);
        }

        ResourceRefNestedImpl() {
            this.builder = new PipelineResourceRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskResourceBindingFluentImpl.this.withResourceRef(this.builder.build());
        }

        @Override
        public N endResourceRef() {
            return this.and();
        }
    }
}

