/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.aspectj;

import io.freefair.gradle.plugins.aspectj.AspectJBasePlugin;
import io.freefair.gradle.plugins.aspectj.AspectJPostCompileWeavingPlugin;
import io.freefair.gradle.plugins.aspectj.AspectjCompile;
import io.freefair.gradle.plugins.aspectj.AspectjSourceDirectorySet;
import io.freefair.gradle.plugins.aspectj.WeavingSourceSet;
import io.freefair.gradle.plugins.aspectj.internal.AspectJUtil;
import io.freefair.gradle.plugins.aspectj.internal.DefaultAspectjSourceDirectorySet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;

public class AspectJPlugin
implements Plugin<Project> {
    private Project project;
    private Provider<JavaLauncher> defaultLauncher;
    private JavaPluginExtension javaExtension;

    public void apply(Project project) {
        if (project.getPlugins().hasPlugin(AspectJPostCompileWeavingPlugin.class)) {
            throw new IllegalStateException("Another aspectj plugin (which is excludes this one) has already been applied to the project.");
        }
        project.getPlugins().withId("com.android.application", ignored -> {
            throw new IllegalStateException("The 'io.freefair.aspectj' plugin is not compatible with android projects");
        });
        project.getPlugins().withId("com.android.library", ignored -> {
            throw new IllegalStateException("The 'io.freefair.aspectj' plugin is not compatible with android projects");
        });
        this.project = project;
        project.getPlugins().apply(AspectJBasePlugin.class);
        project.getPlugins().apply(JavaPlugin.class);
        this.configureJavaBasePlugin(project);
        this.configureJavaPlugin(project);
    }

    private void configureJavaBasePlugin(Project project) {
        this.javaExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        JavaToolchainService service = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        this.defaultLauncher = service.launcherFor(this.javaExtension.getToolchain());
        this.javaExtension.getSourceSets().all(this::configureSourceSet);
    }

    private void configureJavaPlugin(Project project) {
        SourceSet main = (SourceSet)this.javaExtension.getSourceSets().getByName("main");
        SourceSet test = (SourceSet)this.javaExtension.getSourceSets().getByName("test");
        Configuration aspectpath = project.getConfigurations().getByName(WeavingSourceSet.getAspectConfigurationName(main));
        Configuration testAspectpath = project.getConfigurations().getByName(WeavingSourceSet.getAspectConfigurationName(test));
        testAspectpath.extendsFrom(new Configuration[]{aspectpath});
        WeavingSourceSet.getAspectPath(test).setFrom(new Object[]{main.getOutput(), testAspectpath});
    }

    private void configureSourceSet(SourceSet sourceSet) {
        sourceSet.getExtensions().add("inPath", (Object)this.project.getObjects().fileCollection());
        sourceSet.getExtensions().add("aspectPath", (Object)this.project.getObjects().fileCollection());
        String aspectjSrcDisplayName = ((DefaultSourceSet)sourceSet).getDisplayName() + " AspectJ source";
        AspectjSourceDirectorySet aspectjSource = (AspectjSourceDirectorySet)this.project.getObjects().newInstance(DefaultAspectjSourceDirectorySet.class, new Object[]{this.project.getObjects().sourceDirectorySet("aspectj", aspectjSrcDisplayName)});
        sourceSet.getExtensions().add(AspectjSourceDirectorySet.class, "aspectj", (Object)aspectjSource);
        aspectjSource.getFilter().include(new String[]{"**/*.java", "**/*.aj"});
        aspectjSource.srcDir("src/" + sourceSet.getName() + "/aspectj");
        AspectjSourceDirectorySet aspectjSourceFileCollection = aspectjSource;
        sourceSet.getResources().getFilter().exclude(arg_0 -> AspectJPlugin.lambda$configureSourceSet$2((FileCollection)aspectjSourceFileCollection, arg_0));
        sourceSet.getAllJava().source((SourceDirectorySet)aspectjSource);
        sourceSet.getAllSource().source((SourceDirectorySet)aspectjSource);
        SourceDirectorySet allAspectj = this.project.getObjects().sourceDirectorySet("allAspectj", aspectjSrcDisplayName);
        sourceSet.getExtensions().add(SourceDirectorySet.class, "allAspectj", (Object)allAspectj);
        allAspectj.getFilter().include(new String[]{"**/*.java", "**/*.aj"});
        allAspectj.source((SourceDirectorySet)aspectjSource);
        allAspectj.source(sourceSet.getJava());
        Configuration aspect = (Configuration)this.project.getConfigurations().create(WeavingSourceSet.getAspectConfigurationName(sourceSet));
        aspect.exclude(AspectJUtil.getAspectJToolsExclude());
        WeavingSourceSet.getAspectPath(sourceSet).from(new Object[]{aspect});
        Configuration inpath = (Configuration)this.project.getConfigurations().create(WeavingSourceSet.getInpathConfigurationName(sourceSet));
        WeavingSourceSet.getInPath(sourceSet).from(new Object[]{inpath});
        this.project.getConfigurations().getByName(sourceSet.getImplementationConfigurationName()).extendsFrom(new Configuration[]{aspect});
        this.project.getConfigurations().getByName(sourceSet.getCompileOnlyConfigurationName()).extendsFrom(new Configuration[]{inpath});
        TaskProvider compileTask = this.project.getTasks().register(sourceSet.getCompileTaskName("aspectj"), AspectjCompile.class, compile -> {
            JvmPluginsHelper.compileAgainstJavaOutputs((AbstractCompile)compile, (SourceSet)sourceSet, (ObjectFactory)this.project.getObjects());
            JvmPluginsHelper.configureAnnotationProcessorPath((SourceSet)sourceSet, (SourceDirectorySet)aspectjSource, (CompileOptions)compile.getOptions(), (Project)this.project);
            compile.dependsOn(new Object[]{sourceSet.getCompileJavaTaskName()});
            compile.getLauncher().convention(this.defaultLauncher);
            compile.setDescription("Compiles the " + sourceSet.getName() + " AspectJ source.");
            compile.setSource((FileTree)allAspectj);
            compile.getAjcOptions().getAspectpath().from(new Object[]{WeavingSourceSet.getAspectPath(sourceSet)});
            compile.getAjcOptions().getInpath().from(new Object[]{WeavingSourceSet.getInPath(sourceSet)});
        });
        JvmPluginsHelper.configureOutputDirectoryForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)aspectjSource, (Project)this.project, (TaskProvider)compileTask, (Provider)compileTask.map(AspectjCompile::getOptions));
        this.project.getTasks().named(sourceSet.getCompileJavaTaskName()).configure(compileJava -> compileJava.setEnabled(false));
        this.project.getTasks().named(sourceSet.getClassesTaskName(), task -> task.dependsOn(new Object[]{compileTask}));
    }

    private static /* synthetic */ boolean lambda$configureSourceSet$2(FileCollection aspectjSourceFileCollection, FileTreeElement element) {
        return aspectjSourceFileCollection.contains(element.getFile());
    }
}

