/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import io.freefair.gradle.plugins.lombok.tasks.LombokJarTask;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;

@CacheableTask
public abstract class LombokApiJar
extends LombokJarTask {
    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @Inject
    protected abstract ProcessOperations getProcessOperations();

    public LombokApiJar() {
        this.getArchiveAppendix().convention((Object)"api");
    }

    @TaskAction
    public void copy() {
        this.getFileSystemOperations().delete(spec -> spec.delete(new Object[]{this.getArchiveFile()}).setFollowSymlinks(false));
        File destinationDir = (File)this.getDestinationDirectory().getAsFile().get();
        this.getProcessOperations().javaexec(apiJar -> {
            if (this.getLauncher().isPresent()) {
                apiJar.setExecutable(((JavaLauncher)this.getLauncher().get()).getExecutablePath().getAsFile().getAbsolutePath());
            }
            apiJar.setClasspath((FileCollection)this.getLombokClasspath());
            apiJar.getMainClass().set((Object)"lombok.launch.Main");
            apiJar.args(new Object[]{"publicApi", destinationDir.getAbsolutePath()});
        });
        new File(destinationDir, "lombok-api.jar").renameTo(((RegularFile)this.getArchiveFile().get()).getAsFile());
    }
}

