/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import io.freefair.gradle.plugins.lombok.internal.ConfigUtil;
import io.freefair.gradle.plugins.lombok.tasks.LombokTask;
import io.freefair.gradle.plugins.lombok.tasks.internal.LombokConfigAction;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class LombokConfig
extends DefaultTask
implements LombokTask {
    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @Inject
    protected abstract FileOperations getFileOperations();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Override
    @Nested
    @Optional
    public abstract Property<JavaLauncher> getLauncher();

    @Override
    @Classpath
    public abstract ConfigurableFileCollection getLombokClasspath();

    @Input
    public abstract Property<Boolean> getGenerate();

    @Input
    public abstract Property<Boolean> getVerbose();

    @Input
    public abstract Property<Boolean> getNotMentioned();

    @Input
    @Optional
    public abstract ListProperty<String> getKeys();

    @Internal
    public abstract ConfigurableFileCollection getPaths();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Input
    @Optional
    public abstract Property<Boolean> getFork();

    public LombokConfig() {
        this.getGenerate().convention((Object)false);
        this.getVerbose().convention((Object)false);
        this.getNotMentioned().convention((Object)false);
        this.getOutputs().upToDateWhen(t -> ((LombokConfig)t).getConfigFiles() != null);
        this.getOutputs().doNotCacheIf("Config Imports were used", t -> ((LombokConfig)t).getConfigFiles() == null);
    }

    @Input
    protected Set<String> getInputPaths() {
        HashSet<String> paths = new HashSet<String>();
        for (File path : this.getPaths()) {
            try {
                paths.add(this.getFileOperations().relativePath((Object)path));
            }
            catch (Exception e) {
                paths.add(path.toString());
            }
        }
        return paths;
    }

    @InputFiles
    @Optional
    @Nullable
    @PathSensitive(value=PathSensitivity.RELATIVE)
    protected Set<File> getConfigFiles() {
        if (this.getPaths().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<File> configFiles = new HashSet<File>();
        for (File path : this.getPaths()) {
            Set<File> filesForPath = ConfigUtil.resolveConfigFilesForPath(path);
            if (filesForPath == null) {
                return null;
            }
            configFiles.addAll(filesForPath);
        }
        return configFiles;
    }

    @TaskAction
    public void exec() throws IOException {
        this.getFileSystemOperations().delete(spec -> spec.delete(new Object[]{this.getOutputFile()}).setFollowSymlinks(false));
        List actualPaths = this.getPaths().getFiles().stream().filter(File::exists).collect(Collectors.toList());
        if (actualPaths.isEmpty() && !((Boolean)this.getGenerate().get()).booleanValue()) {
            ((RegularFile)this.getOutputFile().get()).getAsFile().createNewFile();
            return;
        }
        LinkedList<Object> args = new LinkedList<Object>();
        if (((Boolean)this.getGenerate().getOrElse((Object)false)).booleanValue()) {
            args.add("--generate");
        }
        if (((Boolean)this.getVerbose().getOrElse((Object)false)).booleanValue()) {
            args.add("--verbose");
        }
        if (((Boolean)this.getNotMentioned().getOrElse((Object)false)).booleanValue()) {
            args.add("--not-mentioned");
        }
        for (String key : (List)this.getKeys().getOrElse(Collections.emptyList())) {
            args.add("--key=" + key.trim());
        }
        for (File path : actualPaths) {
            args.add(path.getAbsolutePath());
        }
        if (((Boolean)this.getFork().getOrElse((Object)false)).booleanValue()) {
            try (OutputStream out = Files.newOutputStream(((File)this.getOutputFile().getAsFile().get()).toPath(), new OpenOption[0]);){
                long start = System.nanoTime();
                this.getExecOperations().javaexec(config -> {
                    if (this.getLauncher().isPresent()) {
                        config.setExecutable(((JavaLauncher)this.getLauncher().get()).getExecutablePath().getAsFile().getAbsolutePath());
                    }
                    config.setClasspath((FileCollection)this.getLombokClasspath());
                    config.setMaxHeapSize("16M");
                    config.getMainClass().set((Object)"lombok.launch.Main");
                    config.args(new Object[]{"config"});
                    config.setStandardOutput(out);
                    config.args((Iterable)args);
                });
                Duration duration = Duration.ofNanos(System.nanoTime() - start);
                if (duration.getSeconds() > 1L) {
                    this.getLogger().warn("lombok config {} took {}ms", args, (Object)duration.toMillis());
                }
                this.getLogger().info("lombok config {} took {}ms", args, (Object)duration.toMillis());
            }
        } else {
            this.getWorkerExecutor().classLoaderIsolation(cl -> cl.getClasspath().from(new Object[]{this.getLombokClasspath()})).submit(LombokConfigAction.class, params -> {
                params.getArgs().set((Iterable)args);
                params.getOutputFile().set((Provider)this.getOutputFile());
            });
        }
    }
}

