/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.app.RunResult;
import io.gatling.app.Runner$;
import io.gatling.app.Selection;
import io.gatling.app.Selection$;
import io.gatling.commons.util.ClockSingleton$;
import io.gatling.commons.util.Ga$;
import io.gatling.core.CoreComponents;
import io.gatling.core.Predef$;
import io.gatling.core.action.Action;
import io.gatling.core.action.Exit;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.ControllerCommand;
import io.gatling.core.controller.throttle.Throttler;
import io.gatling.core.controller.throttle.Throttler$;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.scenario.Simulation;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.stats.DataWritersStatsEngine$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.RunMessage;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005MrAB\u0001\u0003\u0011\u0003\u0011\u0001\"\u0001\u0004Sk:tWM\u001d\u0006\u0003\u0007\u0011\t1!\u00199q\u0015\t)a!A\u0004hCRd\u0017N\\4\u000b\u0003\u001d\t!![8\u0011\u0005%QQ\"\u0001\u0002\u0007\r-\u0011\u0001\u0012\u0001\u0002\r\u0005\u0019\u0011VO\u001c8feN\u0011!\"\u0004\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bQQA\u0011\u0001\f\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\u0003\u0005\u00061)!\t!G\u0001\u0006CB\u0004H.\u001f\u000b\u00065\u0005=\u0012\u0011\u0007\t\u0003\u0013m1Qa\u0003\u0002\u0001\tq\u00192aG\u0007\u001e!\tqR%D\u0001 \u0015\t\u0001\u0013%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002#G\u0005AA/\u001f9fg\u00064WMC\u0001%\u0003\r\u0019w.\\\u0005\u0003M}\u0011Qb\u0015;sS\u000e$Hj\\4hS:<\u0007\u0002\u0003\u0015\u001c\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\rML8\u000f^3n!\tQs&D\u0001,\u0015\taS&A\u0003bGR|'OC\u0001/\u0003\u0011\t7n[1\n\u0005AZ#aC!di>\u00148+_:uK6D\u0001BM\u000e\u0003\u0002\u0003\u0006IaM\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014AB2p]\u001aLwM\u0003\u00029\t\u0005!1m\u001c:f\u0013\tQTG\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006)m!\t\u0001\u0010\u000b\u00045ur\u0004\"\u0002\u0015<\u0001\u0004I\u0003\"\u0002\u001a<\u0001\u0004\u0019\u0004B\u0002!\u001c\t\u0003\u0011\u0011)A\u0002sk:$\"AQ#\u0011\u0005%\u0019\u0015B\u0001#\u0003\u0005%\u0011VO\u001c*fgVdG\u000fC\u0003G\u007f\u0001\u0007q)A\ftK2,7\r^3e'&lW\u000f\\1uS>t7\t\\1tgB\u0011\u0001j\u0013\b\u0003\u0013%K!A\u0013\u0002\u0002\u000fA\f7m[1hK&\u0011A*\u0014\u0002\u0018'\u0016dWm\u0019;fINKW.\u001e7bi&|gn\u00117bgNT!A\u0013\u0002\t\u000b=[B\u0011\u0003)\u0002\u001d9,wo\u0015;biN,enZ5oKR\u0019\u0011kV0\u0011\u0005I+V\"A*\u000b\u0005Q;\u0014!B:uCR\u001c\u0018B\u0001,T\u0005-\u0019F/\u0019;t\u000b:<\u0017N\\3\t\u000bas\u0005\u0019A-\u0002!MLW.\u001e7bi&|g\u000eU1sC6\u001c\bC\u0001.^\u001b\u0005Y&B\u0001/8\u0003!\u00198-\u001a8be&|\u0017B\u00010\\\u0005A\u0019\u0016.\\;mCRLwN\u001c)be\u0006l7\u000fC\u0003a\u001d\u0002\u0007\u0011-\u0001\u0006sk:lUm]:bO\u0016\u0004\"AY3\u000e\u0003\rT!\u0001Z*\u0002\r]\u0014\u0018\u000e^3s\u0013\t17M\u0001\u0006Sk:lUm]:bO\u0016DQ\u0001[\u000e\u0005\u0012%\fAA];oaQ\u0011!I\u001b\u0005\u0006\r\u001e\u0004\ra\u0012\u0005\u0006Yn!\t\"\\\u0001\u0006gR\f'\u000f\u001e\u000b\b]\u0006\u0005\u00111AA\u0012a\tyw\u000fE\u0002qgVl\u0011!\u001d\u0006\u0003e>\tA!\u001e;jY&\u0011A/\u001d\u0002\u0004)JL\bC\u0001<x\u0019\u0001!\u0011\u0002_6\u0002\u0002\u0003\u0005)\u0011A=\u0003\u0007}#\u0013'\u0005\u0002{{B\u0011ab_\u0005\u0003y>\u0011qAT8uQ&tw\r\u0005\u0002\u000f}&\u0011qp\u0004\u0002\u0004\u0003:L\b\"\u0002-l\u0001\u0004I\u0006bBA\u0003W\u0002\u0007\u0011qA\u0001\ng\u000e,g.\u0019:j_N\u0004b!!\u0003\u0002\u0018\u0005ua\u0002BA\u0006\u0003+qA!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#)\u0012A\u0002\u001fs_>$h(C\u0001\u0011\u0013\tQu\"\u0003\u0003\u0002\u001a\u0005m!\u0001\u0002'jgRT!AS\b\u0011\u0007i\u000by\"C\u0002\u0002\"m\u0013\u0001bU2f]\u0006\u0014\u0018n\u001c\u0005\b\u0003KY\u0007\u0019AA\u0014\u00039\u0019wN]3D_6\u0004xN\\3oiN\u0004B!!\u000b\u0002,5\tq'C\u0002\u0002.]\u0012abQ8sK\u000e{W\u000e]8oK:$8\u000fC\u0003)/\u0001\u0007\u0011\u0006C\u00033/\u0001\u00071\u0007")
public class Runner
implements StrictLogging {
    private final ActorSystem system;
    private final GatlingConfiguration configuration;
    private final Logger logger;

    public static Runner apply(ActorSystem actorSystem, GatlingConfiguration gatlingConfiguration) {
        return Runner$.MODULE$.apply(actorSystem, gatlingConfiguration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public RunResult run(Option<Class<Simulation>> selectedSimulationClass) {
        RunResult runResult;
        Option option = this.configuration.core().directory().reportsOnly();
        if (option instanceof Some) {
            Some some = (Some)option;
            String reportsOnly = (String)some.x();
            runResult = new RunResult(reportsOnly, true);
        } else {
            if (this.configuration.http().enableGA()) {
                Ga$.MODULE$.send(this.configuration.core().version());
            }
            runResult = this.run0(selectedSimulationClass);
        }
        return runResult;
    }

    public StatsEngine newStatsEngine(SimulationParams simulationParams, RunMessage runMessage) {
        return DataWritersStatsEngine$.MODULE$.apply(this.system, simulationParams, runMessage, this.configuration);
    }

    public RunResult run0(Option<Class<Simulation>> selectedSimulationClass) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Running");
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        ClockSingleton$.MODULE$.loadClockSingleton();
        Predef$.MODULE$.configuration_$eq(this.configuration);
        Selection selection = Selection$.MODULE$.apply(selectedSimulationClass, this.configuration);
        Simulation simulation = selection.simulationClass().newInstance();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation instantiated");
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        SimulationParams simulationParams = simulation.params(this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation params built");
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        simulation.executeBefore();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Before hooks executed");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        RunMessage runMessage = new RunMessage(simulationParams.name(), selection.userDefinedSimulationId(), selection.defaultSimulationId(), ClockSingleton$.MODULE$.nowMillis(), selection.description());
        StatsEngine statsEngine = this.newStatsEngine(simulationParams, runMessage);
        Throttler throttler = Throttler$.MODULE$.apply(this.system, simulationParams);
        ActorRef controller = this.system.actorOf(Controller$.MODULE$.props(statsEngine, throttler, simulationParams, this.configuration), Controller$.MODULE$.ControllerActorName());
        Exit exit = new Exit(controller, statsEngine);
        CoreComponents coreComponents = new CoreComponents(controller, throttler, statsEngine, (Action)exit, this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("CoreComponents instantiated");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        List scenarios = simulationParams.scenarios(this.system, coreComponents);
        System.gc();
        Try<?> try_ = this.start(simulationParams, (List<Scenario>)scenarios, coreComponents);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            throw t;
        }
        simulation.executeAfter();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("After hooks executed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RunResult runResult = new RunResult(runMessage.runId(), simulationParams.assertions().nonEmpty());
        return runResult;
    }

    public Try<?> start(SimulationParams simulationParams, List<Scenario> scenarios, CoreComponents coreComponents) {
        BoxedUnit boxedUnit;
        FiniteDuration timeout = new package.DurationInt(package$.MODULE$.DurationInt(Integer.MAX_VALUE)).milliseconds().$minus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        long start = ClockSingleton$.MODULE$.nowMillis();
        scala.Predef$.MODULE$.println((Object)new StringContext((Seq)scala.Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Simulation ", " started..."})).s((Seq)scala.Predef$.MODULE$.genericWrapArray((Object)new Object[]{simulationParams.name()})));
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Asking Controller to start");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(coreComponents.controller());
        ControllerCommand.Start x$1 = new ControllerCommand.Start(scenarios);
        Timeout x$2 = Timeout$.MODULE$.durationToTimeout(timeout);
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        Future whenRunDone = AskableActorRef$.MODULE$.ask$extension1(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(Try.class));
        Try runDone = (Try)Await$.MODULE$.result((Awaitable)whenRunDone, (Duration)timeout);
        scala.Predef$.MODULE$.println((Object)new StringContext((Seq)scala.Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Simulation ", " completed in ", " seconds"})).s((Seq)scala.Predef$.MODULE$.genericWrapArray((Object)new Object[]{simulationParams.name(), BoxesRunTime.boxToLong((long)((ClockSingleton$.MODULE$.nowMillis() - start) / 1000L))})));
        return runDone;
    }

    public Runner(ActorSystem system, GatlingConfiguration configuration) {
        this.system = system;
        this.configuration = configuration;
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

