/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import io.gatling.app.RunResult;
import io.gatling.app.RunResultProcessor$;
import io.gatling.app.cli.StatusCode;
import io.gatling.app.cli.StatusCode$AssertionsFailed$;
import io.gatling.app.cli.StatusCode$Success$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.ReportsGenerator;
import io.gatling.charts.stats.LogFileReader;
import io.gatling.commons.stats.GeneralStatsSource;
import io.gatling.commons.stats.assertion.AssertionResult;
import io.gatling.commons.stats.assertion.AssertionValidator$;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}<aAD\b\t\u0002=)bAB\f\u0010\u0011\u0003y\u0001\u0004C\u0003 \u0003\u0011\u0005\u0011\u0005C\u0003#\u0003\u0011\u00051E\u0002\u0003\u0018\u001f\u0001)\u0003\u0002\u0003\u0014\u0005\u0005\u0003\u0005\u000b\u0011B\u0014\t\u000b}!A\u0011A\u0018\t\u000f)\"!\u0019!C\u0006c!1!\u0007\u0002Q\u0001\n\u001dBQa\r\u0003\u0005\u0002QBQ\u0001\u0011\u0003\u0005\n\u0005CQA\u0014\u0003\u0005\n=CQa\u0015\u0003\u0005\nQCQ!\u001a\u0003\u0005\n\u0019\f!CU;o%\u0016\u001cX\u000f\u001c;Qe>\u001cWm]:pe*\u0011\u0001#E\u0001\u0004CB\u0004(B\u0001\n\u0014\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001F\u0001\u0003S>\u0004\"AF\u0001\u000e\u0003=\u0011!CU;o%\u0016\u001cX\u000f\u001c;Qe>\u001cWm]:peN\u0011\u0011!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!F\u0001\u0006CB\u0004H.\u001f\u000b\u0003Iy\u0004\"A\u0006\u0003\u0014\u0005\u0011I\u0012!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u000511m\u001c8gS\u001eT!\u0001L\t\u0002\t\r|'/Z\u0005\u0003]%\u0012AcR1uY&twmQ8oM&<WO]1uS>tGC\u0001\u00131\u0011\u00151c\u00011\u0001(+\u00059\u0013aB2p]\u001aLw\rI\u0001\u0011aJ|7-Z:t%Vt'+Z:vYR$\"!N\u001e\u0011\u0005YJT\"A\u001c\u000b\u0005az\u0011aA2mS&\u0011!h\u000e\u0002\u000b'R\fG/^:D_\u0012,\u0007\"\u0002\u001f\n\u0001\u0004i\u0014!\u0003:v]J+7/\u001e7u!\t1b(\u0003\u0002@\u001f\tI!+\u001e8SKN,H\u000e^\u0001\u0012S:LG\u000fT8h\r&dWMU3bI\u0016\u0014HC\u0001\"N!\rQ2)R\u0005\u0003\tn\u0011aa\u00149uS>t\u0007C\u0001$L\u001b\u00059%B\u0001%J\u0003\u0015\u0019H/\u0019;t\u0015\tQ\u0015#\u0001\u0004dQ\u0006\u0014Ho]\u0005\u0003\u0019\u001e\u0013Q\u0002T8h\r&dWMU3bI\u0016\u0014\b\"\u0002\u001f\u000b\u0001\u0004i\u0014\u0001\u0007:fa>\u0014Ho]$f]\u0016\u0014\u0018\r^5p]\u0016s\u0017M\u00197fIV\t\u0001\u000b\u0005\u0002\u001b#&\u0011!k\u0007\u0002\b\u0005>|G.Z1o\u0003=9WM\\3sCR,'+\u001a9peR\u001cHcA+YAB\u0011!DV\u0005\u0003/n\u0011A!\u00168ji\")\u0011\f\u0004a\u00015\u00069\"/\u001a9peR\u001cx)\u001a8fe\u0006$\u0018n\u001c8J]B,Ho\u001d\t\u00037zk\u0011\u0001\u0018\u0006\u0003;&\u000baA]3q_J$\u0018BA0]\u0005]\u0011V\r]8siN<UM\\3sCRLwN\\%oaV$8\u000fC\u0003b\u0019\u0001\u0007!-A\u0003ti\u0006\u0014H\u000f\u0005\u0002\u001bG&\u0011Am\u0007\u0002\u0005\u0019>tw-A\u0005sk:\u001cF/\u0019;vgR\u0011Qg\u001a\u0005\u0006Q6\u0001\r![\u0001\u0011CN\u001cXM\u001d;j_:\u0014Vm];miN\u00042A\u001b:v\u001d\tY\u0007O\u0004\u0002m_6\tQN\u0003\u0002oA\u00051AH]8pizJ\u0011\u0001H\u0005\u0003cn\tq\u0001]1dW\u0006<W-\u0003\u0002ti\n!A*[:u\u0015\t\t8\u0004\u0005\u0002wy6\tqO\u0003\u0002ys\u0006I\u0011m]:feRLwN\u001c\u0006\u0003\u0011jT!a_\t\u0002\u000f\r|W.\\8og&\u0011Qp\u001e\u0002\u0010\u0003N\u001cXM\u001d;j_:\u0014Vm];mi\")ae\u0001a\u0001O\u0001")
public class RunResultProcessor {
    private final GatlingConfiguration configuration;
    private final GatlingConfiguration config;

    public static RunResultProcessor apply(GatlingConfiguration gatlingConfiguration) {
        return RunResultProcessor$.MODULE$.apply(gatlingConfiguration);
    }

    private GatlingConfiguration config() {
        return this.config;
    }

    public StatusCode processRunResult(RunResult runResult) {
        StatusCode statusCode;
        long start = System.currentTimeMillis();
        Option<LogFileReader> option = this.initLogFileReader(runResult);
        if (option instanceof Some) {
            Some some = (Some)option;
            LogFileReader reader = (LogFileReader)some.value();
            List assertionResults = AssertionValidator$.MODULE$.validateAssertions((GeneralStatsSource)reader);
            if (this.reportsGenerationEnabled()) {
                ReportsGenerationInputs reportsGenerationInputs = new ReportsGenerationInputs(runResult.runId(), reader, assertionResults);
                this.generateReports(reportsGenerationInputs, start);
            }
            statusCode = this.runStatus((List<AssertionResult>)assertionResults);
        } else {
            statusCode = StatusCode$Success$.MODULE$;
        }
        return statusCode;
    }

    private Option<LogFileReader> initLogFileReader(RunResult runResult) {
        return this.reportsGenerationEnabled() || runResult.hasAssertions() ? new Some((Object)new LogFileReader(runResult.runId(), this.config())) : None$.MODULE$;
    }

    private boolean reportsGenerationEnabled() {
        return this.configuration.core().directory().reportsOnly().isDefined() || this.configuration.data().fileDataWriterEnabled() && !this.configuration.charting().noReports();
    }

    private void generateReports(ReportsGenerationInputs reportsGenerationInputs, long start) {
        Predef$.MODULE$.println((Object)"Generating reports...");
        Path indexFile = new ReportsGenerator(this.config()).generateFor(reportsGenerationInputs);
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Reports generated in ").append((System.currentTimeMillis() - start) / 1000L).append("s.").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(32).append("Please open the following file: ").append(indexFile.toFile()).toString());
    }

    private StatusCode runStatus(List<AssertionResult> assertionResults) {
        boolean consolidatedAssertionResult = BoxesRunTime.unboxToBoolean((Object)assertionResults.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(isValid, assertionResult) -> BoxesRunTime.boxToBoolean((boolean)RunResultProcessor.$anonfun$runStatus$1(BoxesRunTime.unboxToBoolean((Object)isValid), assertionResult))));
        return consolidatedAssertionResult ? StatusCode$Success$.MODULE$ : StatusCode$AssertionsFailed$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$runStatus$1(boolean isValid, AssertionResult assertionResult) {
        Predef$.MODULE$.println((Object)new StringBuilder(3).append(assertionResult.message()).append(" : ").append(assertionResult.result()).toString());
        return isValid && assertionResult.result();
    }

    public RunResultProcessor(GatlingConfiguration configuration) {
        this.configuration = configuration;
        this.config = configuration;
    }
}

