/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.app.RunResult;
import io.gatling.app.RunResultProcessor;
import io.gatling.app.Runner;
import io.gatling.app.Runner$;
import io.gatling.app.cli.GatlingArgsParser;
import io.gatling.app.cli.StatusCode;
import io.gatling.core.actor.ActorSystem;
import io.gatling.core.cli.GatlingArgs;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.netty.util.Transports;
import io.netty.channel.EventLoopGroup;
import java.nio.file.FileSystems;
import java.util.concurrent.TimeUnit;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class Gatling$
implements StrictLogging {
    public static final Gatling$ MODULE$ = new Gatling$();
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public void main(String[] args) {
        System.out.flush();
        throw package$.MODULE$.exit(this.fromArgs(args));
    }

    public int fromArgs(String[] args) {
        Either<GatlingArgs, StatusCode> either = new GatlingArgsParser(args).parseArguments();
        if (either instanceof Left) {
            Left left = (Left)either;
            GatlingArgs gatlingArgs = (GatlingArgs)left.value();
            return this.start(gatlingArgs);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            StatusCode statusCode = (StatusCode)right.value();
            return statusCode.code();
        }
        throw new MatchError(either);
    }

    private void terminateActorSystem(ActorSystem system) {
        try {
            system.close();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Could not terminate ActorSystem", throwable2);
                }
            }
            throw throwable;
        }
    }

    private int start(GatlingArgs gatlingArgs) {
        int n;
        try {
            RunResult runResult;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Starting");
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            FileSystems.getDefault();
            GatlingConfiguration configuration = GatlingConfiguration$.MODULE$.load();
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Configuration loaded");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("ActorSystem instantiated");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option option = gatlingArgs.reportsOnly();
            if (option instanceof Some) {
                Some some = (Some)option;
                String runId = (String)some.value();
                runResult = new RunResult(runId, true);
            } else {
                ActorSystem system = new ActorSystem();
                EventLoopGroup eventLoopGroup = Transports.newEventLoopGroup((boolean)configuration.netty().useNativeTransport(), (boolean)configuration.netty().useIoUring(), (int)0, (String)"gatling");
                try {
                    try {
                        BoxedUnit boxedUnit4;
                        Runner runner = Runner$.MODULE$.apply(system, eventLoopGroup, gatlingArgs, configuration);
                        if (this.logger().underlying().isTraceEnabled()) {
                            this.logger().underlying().trace("Runner instantiated");
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        runResult = runner.run();
                    }
                    catch (Throwable e) {
                        BoxedUnit boxedUnit5;
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error("Run crashed", e);
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                        throw e;
                    }
                }
                finally {
                    this.terminateActorSystem(system);
                    eventLoopGroup.shutdownGracefully(0L, configuration.core().shutdownTimeout(), TimeUnit.MILLISECONDS);
                }
            }
            RunResult runResult2 = runResult;
            n = new RunResultProcessor(gatlingArgs, configuration).processRunResult(runResult2).code();
        }
        catch (Throwable throwable) {
            block30: {
                ILoggerFactory factory = LoggerFactory.getILoggerFactory();
                try {
                    factory.getClass().getMethod("stop", new Class[0]).invoke((Object)factory, new Object[0]);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3;
                    Throwable throwable4 = throwable2;
                    if (throwable4 instanceof NoSuchMethodException) {
                        break block30;
                    }
                    if (throwable4 != null && NonFatal$.MODULE$.apply(throwable3 = throwable4)) {
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Logback failed to shutdown.", throwable3);
                        }
                        break block30;
                    }
                    throw throwable2;
                }
            }
            throw throwable;
        }
        int n2 = n;
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        try {
            factory.getClass().getMethod("stop", new Class[0]).invoke((Object)factory, new Object[0]);
        }
        catch (Throwable throwable) {
            Throwable throwable5;
            Throwable throwable6 = throwable;
            if (throwable6 instanceof NoSuchMethodException) {
            }
            if (throwable6 != null && NonFatal$.MODULE$.apply(throwable5 = throwable6)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Logback failed to shutdown.", throwable5);
                }
            }
            throw throwable;
        }
        return n2;
    }

    private Gatling$() {
    }
}

