/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.stats;

import boopickle.Default$;
import boopickle.UnpickleState$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.charts.stats.ErrorRecord;
import io.gatling.charts.stats.ErrorRecordParser$;
import io.gatling.charts.stats.GroupRecord;
import io.gatling.charts.stats.GroupRecordParser;
import io.gatling.charts.stats.LogFileData;
import io.gatling.charts.stats.LogFileReader$;
import io.gatling.charts.stats.RequestRecord;
import io.gatling.charts.stats.RequestRecordParser;
import io.gatling.charts.stats.ResultsHolder;
import io.gatling.charts.stats.RunInfo;
import io.gatling.charts.stats.StatsHelper$;
import io.gatling.charts.stats.UserRecord;
import io.gatling.charts.stats.UserRecordParser$;
import io.gatling.commons.stats.assertion.Assertion;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.message.MessageEvent;
import io.gatling.core.stats.writer.DataWriterMessageSerializer$;
import io.gatling.core.stats.writer.RawAssertionRecord$;
import io.gatling.core.stats.writer.RawErrorRecord$;
import io.gatling.core.stats.writer.RawGroupRecord$;
import io.gatling.core.stats.writer.RawRequestRecord$;
import io.gatling.core.stats.writer.RawRunRecord$;
import io.gatling.core.stats.writer.RawUserRecord$;
import io.gatling.core.stats.writer.RunMessage;
import io.gatling.shared.model.assertion.AssertionPicklers$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005}sA\u0002\n\u0014\u0011\u000392D\u0002\u0004\u001e'!\u0005qC\b\u0005\u0006_\u0005!\t!\r\u0005\be\u0005\u0011\r\u0011\"\u00034\u0011\u00199\u0014\u0001)A\u0005i!9\u0001(\u0001b\u0001\n\u0013I\u0004BB\u001f\u0002A\u0003%!\bC\u0004?\u0003\t\u0007I\u0011B \t\r!\u000b\u0001\u0015!\u0003A\u0011\u0015I\u0015\u0001\"\u0001K\r\u0015i2CA\fM\u0011!i%B!A!\u0002\u0013q\u0005\u0002\u00032\u000b\u0005\u0003\u0005\u000b\u0011B2\t\u000b=RA\u0011A6\t\u000b9TA\u0011A8\t\u000bMTA\u0011\u0002;\t\u000f\u0005\u0005\"\u0002\"\u0003\u0002$!9\u0011q\u0006\u0006\u0005\n\u0005E\u0012!\u0004'pO\u001aKG.\u001a*fC\u0012,'O\u0003\u0002\u0015+\u0005)1\u000f^1ug*\u0011acF\u0001\u0007G\"\f'\u000f^:\u000b\u0005aI\u0012aB4bi2Lgn\u001a\u0006\u00025\u0005\u0011\u0011n\u001c\t\u00039\u0005i\u0011a\u0005\u0002\u000e\u0019><g)\u001b7f%\u0016\fG-\u001a:\u0014\u0007\u0005yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M5j\u0011a\n\u0006\u0003Q%\nAb]2bY\u0006dwnZ4j]\u001eT!AK\u0016\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001L\u0001\u0004G>l\u0017B\u0001\u0018(\u00055\u0019FO]5di2{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001c\u0003\u001daunZ*uKB,\u0012\u0001\u000e\t\u0003AUJ!AN\u0011\u0003\u0007%sG/\u0001\u0005M_\u001e\u001cF/\u001a9!\u0003A\u0019VmY'jY2L7/Z2SCRLw.F\u0001;!\t\u00013(\u0003\u0002=C\t1Ai\\;cY\u0016\f\u0011cU3d\u001b&dG.[:fGJ\u000bG/[8!\u0003i\u0019\u0016.\\;mCRLwN\u001c$jY\u0016\u001ch*Y7f!\u0006$H/\u001a:o+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0011\u0002\u0007'R\u0014\u0018N\\4\u00027MKW.\u001e7bi&|gNR5mKNt\u0015-\\3QCR$XM\u001d8!\u0003\u0015\t\u0007\u000f\u001d7z)\u001dY\u0015QKA-\u0003;\u0002\"\u0001\b\u0006\u0014\u0007)yR%\u0001\u0006j]B,HOR5mKN\u00042aT,[\u001d\t\u0001VK\u0004\u0002R)6\t!K\u0003\u0002Ta\u00051AH]8pizJ\u0011AI\u0005\u0003-\u0006\nq\u0001]1dW\u0006<W-\u0003\u0002Y3\n\u00191+Z9\u000b\u0005Y\u000b\u0003CA.a\u001b\u0005a&BA/_\u0003\u00111\u0017\u000e\\3\u000b\u0005}#\u0015a\u00018j_&\u0011\u0011\r\u0018\u0002\u0005!\u0006$\b.A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\faaY8oM&<'B\u00015\u0018\u0003\u0011\u0019wN]3\n\u0005),'\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g\u000eF\u0002LY6DQ!T\u0007A\u00029CQAY\u0007A\u0002\r\fAA]3bIR\t\u0001\u000f\u0005\u0002\u001dc&\u0011!o\u0005\u0002\f\u0019><g)\u001b7f\t\u0006$\u0018-A\bqCJ\u001cX-\u00138qkR4\u0015\u000e\\3t+\t)\b\u0010F\u0002w\u0003\u0007\u0001\"a\u001e=\r\u0001\u0011)\u0011p\u0004b\u0001u\n\tA+\u0005\u0002|}B\u0011\u0001\u0005`\u0005\u0003{\u0006\u0012qAT8uQ&tw\r\u0005\u0002!\u007f&\u0019\u0011\u0011A\u0011\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0006=\u0001\r!a\u0002\u0002\u0003\u0019\u0004b\u0001IA\u0005\u0003\u001b1\u0018bAA\u0006C\tIa)\u001e8di&|g.\r\t\u0006\u001f\u0006=\u00111C\u0005\u0004\u0003#I&\u0001C%uKJ\fGo\u001c:\u0011\t\u0005U\u0011Q\u0004\b\u0005\u0003/\tI\u0002\u0005\u0002RC%\u0019\u00111D\u0011\u0002\rA\u0013X\rZ3g\u0013\r9\u0015q\u0004\u0006\u0004\u00037\t\u0013!\u00034jeN$\b+Y:t)\u0011\t)#a\u000b\u0011\u0007q\t9#C\u0002\u0002*M\u0011qAU;o\u0013:4w\u000eC\u0004\u0002.A\u0001\r!!\u0004\u0002\u000fI,7m\u001c:eg\u0006Q1/Z2p]\u0012\u0004\u0016m]:\u0015\u0015\u0005M\u0012\u0011HA\u001f\u0003\u000f\n\u0019\u0006E\u0002\u001d\u0003kI1!a\u000e\u0014\u00055\u0011Vm];miNDu\u000e\u001c3fe\"9\u00111H\tA\u0002\u0005\u0015\u0012a\u0002:v]&sgm\u001c\u0005\b\u0003\u007f\t\u0002\u0019AA!\u0003\u001d\u0011WoY6fiN\u0004B\u0001IA\"i%\u0019\u0011QI\u0011\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005%\u0013\u00031\u0001\u0002L\u0005q!-^2lKR4UO\\2uS>t\u0007C\u0002\u0011\u0002\n\u00055C\u0007E\u0002!\u0003\u001fJ1!!\u0015\"\u0005\u0011auN\\4\t\u000f\u00055\u0012\u00031\u0001\u0002\u000e!9\u0011qK\u0005A\u0002\u0005M\u0011a\u0002:v]V+\u0018\u000e\u001a\u0005\u0007\u00037J\u0001\u0019\u0001.\u0002!I,7/\u001e7ug\u0012K'/Z2u_JL\b\"\u00022\n\u0001\u0004\u0019\u0007")
public final class LogFileReader
implements StrictLogging {
    private final Seq<Path> inputFiles;
    private final GatlingConfiguration configuration;
    private Logger logger;

    public static LogFileReader apply(String runUuid, Path resultsDirectory, GatlingConfiguration configuration) {
        return LogFileReader$.MODULE$.apply(runUuid, resultsDirectory, configuration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public LogFileData read() {
        RunInfo runInfo = (RunInfo)this.parseInputFiles((Function1 & Serializable)records -> this.firstPass((Iterator<String>)records));
        double step = StatsHelper$.MODULE$.step((int)package$.MODULE$.floor((double)runInfo.injectStart() / LogFileReader$.MODULE$.io$gatling$charts$stats$LogFileReader$$SecMillisecRatio()), (int)package$.MODULE$.ceil((double)runInfo.injectEnd() / LogFileReader$.MODULE$.io$gatling$charts$stats$LogFileReader$$SecMillisecRatio()), this.configuration.reports().maxPlotsPerSeries()) * LogFileReader$.MODULE$.io$gatling$charts$stats$LogFileReader$$SecMillisecRatio();
        int[] buckets = StatsHelper$.MODULE$.buckets(0L, runInfo.injectEnd() - runInfo.injectStart(), step);
        Function1<Object, Object> bucketFunction = StatsHelper$.MODULE$.timeToBucketNumber(runInfo.injectStart(), step, buckets.length);
        ResultsHolder resultsHolder = (ResultsHolder)this.parseInputFiles((Function1 & Serializable)x$1 -> this.secondPass(runInfo, buckets, bucketFunction, (Iterator<String>)x$1));
        return new LogFileData(runInfo, resultsHolder, step);
    }

    private <T> T parseInputFiles(Function1<Iterator<String>, T> f) {
        Object object;
        Seq streams = (Seq)this.inputFiles.map((Function1 & Serializable)path -> Files.newInputStream(path, new OpenOption[0]));
        try {
            object = f.apply((Object)this.multipleFileIterator$1(streams));
        }
        finally {
            streams.foreach((Function1 & Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
        }
        return (T)object;
    }

    private RunInfo firstPass(Iterator<String> records) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("First pass");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        IntRef count = IntRef.create((int)0);
        LongRef injectStart = LongRef.create((long)Long.MAX_VALUE);
        LongRef injectEnd = LongRef.create((long)Long.MIN_VALUE);
        ListBuffer runMessages = ListBuffer$.MODULE$.empty();
        LinkedHashSet assertions = LinkedHashSet$.MODULE$.empty();
        records.foreach((Function1 & Serializable)line -> {
            Option option;
            Option option2;
            Option option3;
            Option option4;
            Option option5;
            Option option6;
            BoxedUnit boxedUnit;
            ++count$1.elem;
            if (count$1.elem % LogFileReader$.MODULE$.io$gatling$charts$stats$LogFileReader$$LogStep() == 0) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("First pass, read {} lines", (Object)BoxesRunTime.boxToInteger((int)count$1.elem));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            String[] stringArray = line.split(DataWriterMessageSerializer$.MODULE$.Separator());
            if (stringArray != null && !(option6 = RawRequestRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                String[] array = (String[])option6.get();
                LogFileReader.updateInjectStart$1(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[3])), injectStart);
                LogFileReader.updateInjectEnd$1(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[4])), injectEnd);
                return BoxedUnit.UNIT;
            }
            if (stringArray != null && !(option5 = RawUserRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                String[] array = (String[])option5.get();
                long timestamp = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[3]));
                String string = array[2];
                String string2 = MessageEvent.Start$.MODULE$.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    LogFileReader.updateInjectStart$1(timestamp, injectStart);
                }
                LogFileReader.updateInjectEnd$1(timestamp, injectEnd);
                return BoxedUnit.UNIT;
            }
            if (stringArray != null && !(option4 = RawGroupRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                String[] array = (String[])option4.get();
                LogFileReader.updateInjectStart$1(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[2])), injectStart);
                LogFileReader.updateInjectEnd$1(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[3])), injectEnd);
                return BoxedUnit.UNIT;
            }
            if (stringArray != null && !(option3 = RawRunRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                String[] array = (String[])option3.get();
                return runMessages.$plus$eq((Object)new RunMessage(array[1], array[2], StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(array[3])), array[4].trim(), array[5].trim(), $this.configuration.data().zoneId()));
            }
            if (stringArray != null && !(option2 = RawAssertionRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                String[] array = (String[])option2.get();
                String base64String = array[1];
                byte[] bytes = Base64.getDecoder().decode(base64String);
                Assertion assertion = (Assertion)Default$.MODULE$.Unpickle().apply(AssertionPicklers$.MODULE$.AssertionPickler()).fromBytes(ByteBuffer.wrap(bytes), UnpickleState$.MODULE$.unpickleStateSpeed());
                return assertions.$plus$eq((Object)assertion);
            }
            if (stringArray != null && !(option = RawErrorRecord$.MODULE$.unapply(stringArray)).isEmpty()) {
                return BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Record broken on line {}: {}", new Object[]{BoxesRunTime.boxToInteger((int)count$1.elem), line});
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("First pass done: read {} lines", (Object)BoxesRunTime.boxToInteger((int)count.elem));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RunMessage runMessage = (RunMessage)runMessages.headOption().getOrElse((Function0 & Serializable)() -> {
            throw new UnsupportedOperationException("Files " + $this.inputFiles + " don't contain any valid run record");
        });
        Predef$.MODULE$.assert(injectStart.elem != Long.MAX_VALUE, (Function0 & Serializable)() -> "Undefined run start");
        Predef$.MODULE$.assert(injectEnd.elem != Long.MIN_VALUE, (Function0 & Serializable)() -> "Undefined run end");
        Predef$.MODULE$.assert(injectEnd.elem > injectStart.elem, (Function0 & Serializable)() -> "Run didn't last");
        return new RunInfo(injectStart.elem, injectEnd.elem, runMessage.simulationClassName(), runMessage.runId(), runMessage.runDescription(), (List<Assertion>)assertions.toList());
    }

    private ResultsHolder secondPass(RunInfo runInfo, int[] buckets, Function1<Object, Object> bucketFunction, Iterator<String> records) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Second pass");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ResultsHolder resultsHolder = new ResultsHolder(runInfo.injectStart(), runInfo.injectEnd(), buckets, this.configuration.reports().indicators().lowerBound(), this.configuration.reports().indicators().higherBound());
        IntRef count = IntRef.create((int)0);
        RequestRecordParser requestRecordParser = new RequestRecordParser(bucketFunction);
        GroupRecordParser groupRecordParser = new GroupRecordParser(bucketFunction);
        records.foreach((Function1 & Serializable)line -> {
            LogFileReader.$anonfun$secondPass$1(this, count, requestRecordParser, resultsHolder, groupRecordParser, line);
            return BoxedUnit.UNIT;
        });
        resultsHolder.endDandlingStartedUser();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Second pass: read {} lines", (Object)BoxesRunTime.boxToInteger((int)count.elem));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return resultsHolder;
    }

    private final Iterator multipleFileIterator$1(Seq streams) {
        return (Iterator)((IterableOnceOps)streams.map((Function1 & Serializable)x$2 -> Source$.MODULE$.fromInputStream(x$2, Codec$.MODULE$.charset2codec($this.configuration.core().charset())).getLines())).reduce((Function2 & Serializable)(first, second) -> first.$plus$plus((Function0 & Serializable)() -> second));
    }

    private static final void updateInjectStart$1(long eventStart, LongRef injectStart$1) {
        injectStart$1.elem = package$.MODULE$.min(injectStart$1.elem, eventStart);
    }

    private static final void updateInjectEnd$1(long eventEnd, LongRef injectEnd$1) {
        injectEnd$1.elem = package$.MODULE$.max(injectEnd$1.elem, eventEnd);
    }

    public static final /* synthetic */ void $anonfun$secondPass$1(LogFileReader $this, IntRef count$2, RequestRecordParser requestRecordParser$1, ResultsHolder resultsHolder$1, GroupRecordParser groupRecordParser$1, String line) {
        Option<ErrorRecord> option;
        Option<UserRecord> option2;
        Option<GroupRecord> option3;
        Option<RequestRecord> option4;
        BoxedUnit boxedUnit;
        ++count$2.elem;
        if (count$2.elem % LogFileReader$.MODULE$.io$gatling$charts$stats$LogFileReader$$LogStep() == 0) {
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Second pass, read {} lines", (Object)BoxesRunTime.boxToInteger((int)count$2.elem));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String[] stringArray = line.split(DataWriterMessageSerializer$.MODULE$.Separator());
        if (stringArray != null && !(option4 = requestRecordParser$1.unapply(stringArray)).isEmpty()) {
            RequestRecord record = (RequestRecord)option4.get();
            resultsHolder$1.addRequestRecord(record);
            return;
        }
        if (stringArray != null && !(option3 = groupRecordParser$1.unapply(stringArray)).isEmpty()) {
            GroupRecord record = (GroupRecord)option3.get();
            resultsHolder$1.addGroupRecord(record);
            return;
        }
        if (stringArray != null && !(option2 = UserRecordParser$.MODULE$.unapply(stringArray)).isEmpty()) {
            UserRecord record = (UserRecord)option2.get();
            resultsHolder$1.addUserRecord(record);
            return;
        }
        if (stringArray != null && !(option = ErrorRecordParser$.MODULE$.unapply(stringArray)).isEmpty()) {
            ErrorRecord record = (ErrorRecord)option.get();
            resultsHolder$1.addErrorRecord(record);
            return;
        }
    }

    public LogFileReader(Seq<Path> inputFiles, GatlingConfiguration configuration) {
        this.inputFiles = inputFiles;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

