/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.AssertionsTableComponent;
import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.ErrorsTableComponent;
import io.gatling.charts.component.GlobalStatsTableComponent;
import io.gatling.charts.component.SimulationCardComponent;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.report.GroupContainer;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.SchemaContainerComponent;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.Group;
import io.gatling.charts.stats.LogFileData;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.Ranges;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.stats.UserSeries;
import io.gatling.charts.template.GlobalPageTemplate;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.ReportsConfiguration;
import io.gatling.shared.model.assertion.AssertionResult;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.time.ZoneId;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%b!B\t\u0013\u0005QQ\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u00115\u0002!\u0011!Q\u0001\n9B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!y\u0006A!A!\u0002\u0013\u0001\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u000b=\u0004A\u0011\u00019\t\u000bi\u0004A\u0011B>\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!9\u0011q\u0001\u0001\u0005\n\u0005%\u0001bBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!a\b\u0001\t\u0003\t\tCA\u000bHY>\u0014\u0017\r\u001c*fa>\u0014HoR3oKJ\fGo\u001c:\u000b\u0005M!\u0012A\u0002:fa>\u0014HO\u0003\u0002\u0016-\u000511\r[1siNT!a\u0006\r\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011$\u0001\u0002j_N\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u00113%D\u0001\u0013\u0013\t!#CA\bSKB|'\u000f^$f]\u0016\u0014\u0018\r^8s\u0003-awn\u001a$jY\u0016$\u0015\r^1\u0004\u0001A\u0011\u0001fK\u0007\u0002S)\u0011!\u0006F\u0001\u0006gR\fGo]\u0005\u0003Y%\u00121\u0002T8h\r&dW\rR1uC\u0006\u0001\u0012m]:feRLwN\u001c*fgVdGo\u001d\t\u0004_]RdB\u0001\u00196\u001d\t\tD'D\u00013\u0015\t\u0019d%\u0001\u0004=e>|GOP\u0005\u0002=%\u0011a'H\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0014H\u0001\u0003MSN$(B\u0001\u001c\u001e!\tY$)D\u0001=\u0015\tid(A\u0005bgN,'\u000f^5p]*\u0011q\bQ\u0001\u0006[>$W\r\u001c\u0006\u0003\u0003Z\taa\u001d5be\u0016$\u0017BA\"=\u0005=\t5o]3si&|gNU3tk2$\u0018!\u0004:p_R\u001cuN\u001c;bS:,'\u000f\u0005\u0002#\r&\u0011qI\u0005\u0002\u000f\u000fJ|W\u000f]\"p]R\f\u0017N\\3s\u0003-\u0019\u0007.\u0019:ug\u001aKG.Z:\u0011\u0005)kU\"A&\u000b\u00051#\u0012AB2p]\u001aLw-\u0003\u0002O\u0017\nY1\t[1siN4\u0015\u000e\\3t\u0003A\u0019w.\u001c9p]\u0016tG\u000fT5ce\u0006\u0014\u0018\u0010\u0005\u0002R)6\t!K\u0003\u0002T)\u0005I1m\\7q_:,g\u000e^\u0005\u0003+J\u0013\u0001cQ8na>tWM\u001c;MS\n\u0014\u0018M]=\u0002\ri|g.Z%e!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0003uS6,'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=f\u0013aAW8oK&#\u0017aB2iCJ\u001cX\r\u001e\t\u0003C\u0016l\u0011A\u0019\u0006\u0003?\u000eT!\u0001Z.\u0002\u00079Lw.\u0003\u0002gE\n91\t[1sg\u0016$\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002j[6\t!N\u0003\u0002MW*\u0011ANF\u0001\u0005G>\u0014X-\u0003\u0002oU\n!\"+\u001a9peR\u001c8i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtD#C9sgR,ho\u001e=z!\t\u0011\u0003\u0001C\u0003&\u0013\u0001\u0007q\u0005C\u0003.\u0013\u0001\u0007a\u0006C\u0003E\u0013\u0001\u0007Q\tC\u0003I\u0013\u0001\u0007\u0011\nC\u0003P\u0013\u0001\u0007\u0001\u000bC\u0003W\u0013\u0001\u0007q\u000bC\u0003`\u0013\u0001\u0007\u0001\rC\u0003h\u0013\u0001\u0007\u0001.\u0001\fvg\u0016\u00148\u000b^1siJ\u000bG/Z\"p[B|g.\u001a8u)\tax\u0010\u0005\u0002R{&\u0011aP\u0015\u0002\n\u0007>l\u0007o\u001c8f]RDQ!\n\u0006A\u0002\u001d\n1%\\1y\u001dVl'-\u001a:PM\u000e{gnY;se\u0016tG/V:feN\u001cu.\u001c9p]\u0016tG\u000fF\u0002}\u0003\u000bAQ!J\u0006A\u0002\u001d\naE]3ta>t7/\u001a+j[\u0016$\u0015n\u001d;sS\n,H/[8o\u0007\"\f'\u000f^\"p[B|g.\u001a8u)\ra\u00181\u0002\u0005\u0006K1\u0001\raJ\u0001\u001be\u0016\u001c\bo\u001c8tKRKW.Z\"iCJ$8i\\7q_:,g\u000e\u001e\u000b\u0004y\u0006E\u0001\"B\u0013\u000e\u0001\u00049\u0013A\u0006:fcV,7\u000f^:DQ\u0006\u0014HoQ8na>tWM\u001c;\u0015\u0007q\f9\u0002C\u0003&\u001d\u0001\u0007q%A\fsKN\u0004xN\\:fg\u000eC\u0017M\u001d;D_6\u0004xN\\3oiR\u0019A0!\b\t\u000b\u0015z\u0001\u0019A\u0014\u0002\u0011\u001d,g.\u001a:bi\u0016$\"!a\t\u0011\u0007q\t)#C\u0002\u0002(u\u0011A!\u00168ji\u0002")
public final class GlobalReportGenerator
implements ReportGenerator {
    private final LogFileData logFileData;
    private final List<AssertionResult> assertionResults;
    private final GroupContainer rootContainer;
    private final ChartsFiles chartsFiles;
    private final ComponentLibrary componentLibrary;
    private final ZoneId zoneId;
    private final Charset charset;
    private final ReportsConfiguration configuration;

    private Component userStartRateComponent(LogFileData logFileData) {
        List userStartRateSeries = logFileData.scenarioNames().map((Function1 & Serializable)scenarioName -> new UserSeries((String)scenarioName, logFileData.userStartRatePerSecond((Option<String>)new Some(scenarioName)))).reverse();
        return this.componentLibrary.getUserStartRateComponent(logFileData.runInfo().injectStart(), new UserSeries("All users", logFileData.userStartRatePerSecond((Option<String>)None$.MODULE$)), (Seq<UserSeries>)userStartRateSeries);
    }

    private Component maxNumberOfConcurrentUsersComponent(LogFileData logFileData) {
        List userStartRateSeries = logFileData.scenarioNames().map((Function1 & Serializable)scenarioName -> new UserSeries((String)scenarioName, logFileData.maxNumberOfConcurrentUsersPerSecond((Option<String>)new Some(scenarioName)))).reverse();
        return this.componentLibrary.getMaxConcurrentUsersComponent(logFileData.runInfo().injectStart(), new UserSeries("All users", logFileData.maxNumberOfConcurrentUsersPerSecond((Option<String>)None$.MODULE$)), (Seq<UserSeries>)userStartRateSeries);
    }

    private Component responseTimeDistributionChartComponent(LogFileData logFileData) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = logFileData.responseTimeDistribution(100, (Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq okDistribution = (Seq)tuple2._1();
        Seq koDistribution = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)okDistribution, (Object)koDistribution);
        Seq okDistribution2 = (Seq)tuple22._1();
        Seq koDistribution2 = (Seq)tuple22._2();
        return this.componentLibrary.getDistributionComponent("Response Time", "Requests", (Seq<PercentVsTimePlot>)okDistribution2, (Seq<PercentVsTimePlot>)koDistribution2);
    }

    private Component responseTimeChartComponent(LogFileData logFileData) {
        return this.componentLibrary.getPercentilesOverTimeComponent("Response Time Percentiles over Time (" + Series$.MODULE$.OK() + ")", "Response Time", logFileData.runInfo().injectStart(), logFileData.responseTimePercentilesOverTime((Status)OK$.MODULE$, (Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$));
    }

    private Component requestsChartComponent(LogFileData logFileData) {
        return this.componentLibrary.getRequestsComponent(logFileData.runInfo().injectStart(), (Seq<CountsVsTimePlot>)((Seq)logFileData.numberOfRequestsPerSecond((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.time()), (Ordering)Ordering.Int$.MODULE$)));
    }

    private Component responsesChartComponent(LogFileData logFileData) {
        return this.componentLibrary.getResponsesComponent(logFileData.runInfo().injectStart(), (Seq<CountsVsTimePlot>)((Seq)logFileData.numberOfResponsesPerSecond((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$).sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.time()), (Ordering)Ordering.Int$.MODULE$)));
    }

    @Override
    public void generate() {
        Ranges ranges = this.logFileData.numberOfRequestInResponseTimeRanges((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$);
        GlobalPageTemplate template = new GlobalPageTemplate(this.logFileData.runInfo(), this.rootContainer, (Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{new SchemaContainerComponent((Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{this.componentLibrary.getRangesComponent("Response Time Ranges", "requests", ranges, false), this.componentLibrary.getRequestCountPolarComponent(this.rootContainer), new SimulationCardComponent(this.logFileData.runInfo(), this.zoneId)})), new AssertionsTableComponent(this.assertionResults), new GlobalStatsTableComponent(this.rootContainer, this.configuration.indicators()), new ErrorsTableComponent(this.logFileData.errors((Option<String>)None$.MODULE$, (Option<Group>)None$.MODULE$)), this.userStartRateComponent(this.logFileData), this.maxNumberOfConcurrentUsersComponent(this.logFileData), this.responseTimeDistributionChartComponent(this.logFileData), this.responseTimeChartComponent(this.logFileData), this.requestsChartComponent(this.logFileData), this.responsesChartComponent(this.logFileData)}));
        new TemplateWriter(this.chartsFiles.globalFile()).writeToFile(template.getOutput(), this.charset);
    }

    public GlobalReportGenerator(LogFileData logFileData, List<AssertionResult> assertionResults, GroupContainer rootContainer, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, ZoneId zoneId, Charset charset, ReportsConfiguration configuration) {
        this.logFileData = logFileData;
        this.assertionResults = assertionResults;
        this.rootContainer = rootContainer;
        this.chartsFiles = chartsFiles;
        this.componentLibrary = componentLibrary;
        this.zoneId = zoneId;
        this.charset = charset;
        this.configuration = configuration;
    }
}

