/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.commons.util;

import io.gatling.commons.util.FastByteArrayOutputStream$;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import scala.Array$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005urA\u0002\u0012$\u0011\u0003\u00193F\u0002\u0004.G!\u00051E\f\u0005\u0006k\u0005!\ta\u000e\u0005\u0007q\u0005\u0001\u000b\u0011B\u001d\t\u000f\u0005e\u0012\u0001\"\u0001\u0002<\u0019)Qf\t\u0002$\u0005\"A\u0001*\u0002B\u0001B\u0003%\u0011\nC\u00036\u000b\u0011\u0005A\nC\u0004O\u000b\t\u0007I\u0011B(\t\rm+\u0001\u0015!\u0003Q\u0011\u001daV\u00011A\u0005\nuCqAX\u0003A\u0002\u0013%q\f\u0003\u0004f\u000b\u0001\u0006K!\u0013\u0005\bM\u0016\u0001\r\u0011\"\u0003^\u0011\u001d9W\u00011A\u0005\n!DaA[\u0003!B\u0013I\u0005\"C6\u0006\u0001\u0004\u0005\r\u0011\"\u0003m\u0011%iW\u00011AA\u0002\u0013%a\u000eC\u0005q\u000b\u0001\u0007\t\u0011)Q\u0005+\"9\u0011/\u0002a\u0001\n\u0013i\u0006b\u0002:\u0006\u0001\u0004%Ia\u001d\u0005\u0007k\u0016\u0001\u000b\u0015B%\t\u000fY,\u0001\u0019!C\u0005o\"910\u0002a\u0001\n\u0013a\bB\u0002@\u0006A\u0003&\u0001\u0010\u0003\u0004\u0000\u000b\u0011%\u0011\u0011\u0001\u0005\b\u0003\u000f)A\u0011IA\u0005\u0011\u001d\t9!\u0002C\u0001\u0003/Aq!a\u0002\u0006\t\u0003\tY\u0002\u0003\u0004\u0002(\u0015!\t!\u0018\u0005\b\u0003S)A\u0011IA\u0016\u0011\u001d\ti#\u0002C\u0001\u0003WAq!a\f\u0006\t\u0003\t\t\u0004\u0003\u0004\u00028\u0015!\t\u0001\\\u0001\u001a\r\u0006\u001cHOQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fWN\u0003\u0002%K\u0005!Q\u000f^5m\u0015\t1s%A\u0004d_6lwN\\:\u000b\u0005!J\u0013aB4bi2Lgn\u001a\u0006\u0002U\u0005\u0011\u0011n\u001c\t\u0003Y\u0005i\u0011a\t\u0002\u001a\r\u0006\u001cHOQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fWn\u0005\u0002\u0002_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002W\u0005!\u0001k\\8m!\rQt(Q\u0007\u0002w)\u0011A(P\u0001\u0005Y\u0006twMC\u0001?\u0003\u0011Q\u0017M^1\n\u0005\u0001[$a\u0003+ie\u0016\fG\rT8dC2\u0004\"\u0001L\u0003\u0014\u0005\u0015\u0019\u0005C\u0001#G\u001b\u0005)%B\u0001\u0016>\u0013\t9UI\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.A\u0006j]&$\u0018.\u00197TSj,\u0007C\u0001\u0019K\u0013\tY\u0015GA\u0002J]R$\"!Q'\t\u000b!;\u0001\u0019A%\u0002\u000f\t,hMZ3sgV\t\u0001\u000bE\u0002R'Vk\u0011A\u0015\u0006\u0003IuJ!\u0001\u0016*\u0003\u0013\u0005\u0013(/Y=MSN$\bc\u0001\u0019W1&\u0011q+\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003aeK!AW\u0019\u0003\t\tKH/Z\u0001\tEV4g-\u001a:tA\u0005\u00112-\u001e:sK:$()\u001e4gKJLe\u000eZ3y+\u0005I\u0015AF2veJ,g\u000e\u001e\"vM\u001a,'/\u00138eKb|F%Z9\u0015\u0005\u0001\u001c\u0007C\u0001\u0019b\u0013\t\u0011\u0017G\u0001\u0003V]&$\bb\u00023\f\u0003\u0003\u0005\r!S\u0001\u0004q\u0012\n\u0014aE2veJ,g\u000e\u001e\"vM\u001a,'/\u00138eKb\u0004\u0013a\u00044jY2,GMQ;gM\u0016\u00148+^7\u0002'\u0019LG\u000e\\3e\u0005V4g-\u001a:Tk6|F%Z9\u0015\u0005\u0001L\u0007b\u00023\u000f\u0003\u0003\u0005\r!S\u0001\u0011M&dG.\u001a3Ck\u001a4WM]*v[\u0002\nQbY;se\u0016tGOQ;gM\u0016\u0014X#A+\u0002#\r,(O]3oi\n+hMZ3s?\u0012*\u0017\u000f\u0006\u0002a_\"9A-EA\u0001\u0002\u0004)\u0016AD2veJ,g\u000e\u001e\"vM\u001a,'\u000fI\u0001\u0006G>,h\u000e^\u0001\nG>,h\u000e^0%KF$\"\u0001\u0019;\t\u000f\u0011$\u0012\u0011!a\u0001\u0013\u000611m\\;oi\u0002\nAB]3vg\u0016\u0014UO\u001a4feN,\u0012\u0001\u001f\t\u0003aeL!A_\u0019\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\"/Z;tK\n+hMZ3sg~#S-\u001d\u000b\u0003AvDq\u0001Z\f\u0002\u0002\u0003\u0007\u00010A\u0007sKV\u001cXMQ;gM\u0016\u00148\u000fI\u0001\u000e]\u0016,GMT3x\u0005V4g-\u001a:\u0015\u0007\u0001\f\u0019\u0001\u0003\u0004\u0002\u0006e\u0001\r!S\u0001\t]\u0016<8m\\;oi\u0006)qO]5uKR9\u0001-a\u0003\u0002\u0010\u0005M\u0001BBA\u00075\u0001\u0007Q+A\u0001c\u0011\u0019\t\tB\u0007a\u0001\u0013\u0006\u0019qN\u001a4\t\r\u0005U!\u00041\u0001J\u0003\raWM\u001c\u000b\u0004A\u0006e\u0001BBA\u00077\u0001\u0007\u0011\nF\u0002J\u0003;Aq!a\b\u001d\u0001\u0004\t\t#\u0001\u0002j]B\u0019A)a\t\n\u0007\u0005\u0015RIA\u0006J]B,Ho\u0015;sK\u0006l\u0017\u0001B:ju\u0016\fQa\u00197pg\u0016$\u0012\u0001Y\u0001\u0006e\u0016\u001cX\r^\u0001\boJLG/\u001a+p)\r\u0001\u00171\u0007\u0005\u0007\u0003k\u0001\u0003\u0019A\"\u0002\u0007=,H/A\u0006u_\nKH/Z!se\u0006L\u0018A\u00029p_2,G\rF\u0001B\u0001")
public final class FastByteArrayOutputStream
extends OutputStream {
    private final ArrayList<byte[]> buffers = new ArrayList();
    private int currentBufferIndex = 0;
    private int filledBufferSum = 0;
    private byte[] currentBuffer;
    private int count = 0;
    private boolean reuseBuffers = true;

    public static FastByteArrayOutputStream pooled() {
        return FastByteArrayOutputStream$.MODULE$.pooled();
    }

    private ArrayList<byte[]> buffers() {
        return this.buffers;
    }

    private int currentBufferIndex() {
        return this.currentBufferIndex;
    }

    private void currentBufferIndex_$eq(int x$1) {
        this.currentBufferIndex = x$1;
    }

    private int filledBufferSum() {
        return this.filledBufferSum;
    }

    private void filledBufferSum_$eq(int x$1) {
        this.filledBufferSum = x$1;
    }

    private byte[] currentBuffer() {
        return this.currentBuffer;
    }

    private void currentBuffer_$eq(byte[] x$1) {
        this.currentBuffer = x$1;
    }

    private int count() {
        return this.count;
    }

    private void count_$eq(int x$1) {
        this.count = x$1;
    }

    private boolean reuseBuffers() {
        return this.reuseBuffers;
    }

    private void reuseBuffers_$eq(boolean x$1) {
        this.reuseBuffers = x$1;
    }

    private void needNewBuffer(int newcount) {
        if (this.currentBufferIndex() < this.buffers().size() - 1) {
            this.filledBufferSum_$eq(this.filledBufferSum() + this.currentBuffer().length);
            this.currentBufferIndex_$eq(this.currentBufferIndex() + 1);
            this.currentBuffer_$eq(this.buffers().get(this.currentBufferIndex()));
            return;
        }
        int newBufferSize = 0;
        if (this.currentBuffer() == null) {
            newBufferSize = newcount;
            this.filledBufferSum_$eq(0);
        } else {
            newBufferSize = Math.max(this.currentBuffer().length << 1, newcount - this.filledBufferSum());
            this.filledBufferSum_$eq(this.filledBufferSum() + this.currentBuffer().length);
        }
        this.currentBufferIndex_$eq(this.currentBufferIndex() + 1);
        this.currentBuffer_$eq(new byte[newBufferSize]);
        this.buffers().add(this.currentBuffer());
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len != 0) {
            int newCount = this.count() + len;
            int remaining = len;
            int inBufferPos = this.count() - this.filledBufferSum();
            while (remaining > 0) {
                int part = Math.min(remaining, this.currentBuffer().length - inBufferPos);
                System.arraycopy(b, off + len - remaining, this.currentBuffer(), inBufferPos, part);
                if ((remaining -= part) <= 0) continue;
                this.needNewBuffer(newCount);
                inBufferPos = 0;
            }
            this.count_$eq(newCount);
            return;
        }
    }

    @Override
    public void write(int b) {
        int inBufferPos = this.count() - this.filledBufferSum();
        if (inBufferPos == this.currentBuffer().length) {
            this.needNewBuffer(this.count() + 1);
            inBufferPos = 0;
        }
        this.currentBuffer()[inBufferPos] = (byte)b;
        this.count_$eq(this.count() + 1);
    }

    public int write(InputStream in) {
        int readCount = 0;
        int inBufferPos = this.count() - this.filledBufferSum();
        int n = in.read(this.currentBuffer(), inBufferPos, this.currentBuffer().length - inBufferPos);
        while (n != -1) {
            readCount += n;
            this.count_$eq(this.count() + n);
            if ((inBufferPos += n) == this.currentBuffer().length) {
                this.needNewBuffer(this.currentBuffer().length);
                inBufferPos = 0;
            }
            n = in.read(this.currentBuffer(), inBufferPos, this.currentBuffer().length - inBufferPos);
        }
        return readCount;
    }

    public int size() {
        return this.count();
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.count_$eq(0);
        this.filledBufferSum_$eq(0);
        this.currentBufferIndex_$eq(0);
        if (this.reuseBuffers()) {
            this.currentBuffer_$eq(this.buffers().get(this.currentBufferIndex()));
            return;
        }
        this.currentBuffer_$eq(null);
        int size = this.buffers().get(0).length;
        this.buffers().clear();
        this.needNewBuffer(size);
        this.reuseBuffers_$eq(true);
    }

    public void writeTo(OutputStream out) {
        int c;
        int remaining = this.count();
        for (int buffersIndex = 0; remaining > 0 && buffersIndex < this.buffers().size(); remaining -= c, ++buffersIndex) {
            byte[] buf = this.buffers().get(buffersIndex);
            c = Math.min(buf.length, remaining);
            out.write(buf, 0, c);
        }
    }

    public byte[] toByteArray() {
        int c;
        if (this.count() == 0) {
            return Array$.MODULE$.emptyByteArray();
        }
        int remaining = this.count();
        byte[] newbuf = new byte[remaining];
        int pos = 0;
        for (int buffersIndex = 0; remaining > 0 && buffersIndex < this.buffers().size(); remaining -= c, ++buffersIndex) {
            byte[] buf = this.buffers().get(buffersIndex);
            c = Math.min(buf.length, remaining);
            System.arraycopy(buf, 0, newbuf, pos, c);
            pos += c;
        }
        return newbuf;
    }

    public FastByteArrayOutputStream(int initialSize) {
        this.needNewBuffer(initialSize);
    }
}

