/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.commons.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.GatlingVersion;
import io.gatling.commons.util.Io;
import io.gatling.commons.util.Io$;
import io.gatling.commons.util.LatestGatlingRelease;
import io.gatling.commons.util.LatestGatlingRelease$OnFailureTry$;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.prefs.Preferences;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class LatestGatlingRelease$
implements StrictLogging {
    public static final LatestGatlingRelease$ MODULE$ = new LatestGatlingRelease$();
    private static final Preferences Prefs;
    private static final String LastCheckTimestampPref;
    private static final String LastCheckSuccessPref;
    private static final String LatestReleaseNumberPref;
    private static final String LatestReleaseDatePref;
    private static final String MavenCentralQuery;
    private static final int MavenCentralQueryTimeoutMillis;
    private static final Regex MavenCentralQueryVersionRegex;
    private static final Regex MavenCentralQueryTimestampRegex;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        Prefs = Preferences.userRoot().node("/io/gatling/latestVersion");
        LastCheckTimestampPref = "lastCheckTimestamp";
        LastCheckSuccessPref = "lastCheckSuccess";
        LatestReleaseNumberPref = "latestReleaseNumber";
        LatestReleaseDatePref = "latestReleaseDate";
        MavenCentralQuery = "https://search.maven.org/solrsearch/select?q=g:io.gatling+AND+a:gatling-core+AND+p:jar&rows=1&wt=json&core=gav";
        MavenCentralQueryTimeoutMillis = 1000;
        MavenCentralQueryVersionRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"v\":\\s*\"(.+?)\""));
        MavenCentralQueryTimestampRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"timestamp\":\\s*(\\d+)"));
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private Preferences Prefs() {
        return Prefs;
    }

    private String LastCheckTimestampPref() {
        return LastCheckTimestampPref;
    }

    private String LastCheckSuccessPref() {
        return LastCheckSuccessPref;
    }

    private String LatestReleaseNumberPref() {
        return LatestReleaseNumberPref;
    }

    private String LatestReleaseDatePref() {
        return LatestReleaseDatePref;
    }

    private String MavenCentralQuery() {
        return MavenCentralQuery;
    }

    private int MavenCentralQueryTimeoutMillis() {
        return MavenCentralQueryTimeoutMillis;
    }

    private Regex MavenCentralQueryVersionRegex() {
        return MavenCentralQueryVersionRegex;
    }

    private Regex MavenCentralQueryTimestampRegex() {
        return MavenCentralQueryTimestampRegex;
    }

    private Try<LatestGatlingRelease.FetchResult> loadPersisted() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            long lastCheckTimestamp = MODULE$.Prefs().getLong(MODULE$.LastCheckTimestampPref(), 0L);
            return MODULE$.Prefs().getBoolean(MODULE$.LastCheckSuccessPref(), false) ? new LatestGatlingRelease.FetchResult.Success(lastCheckTimestamp, new GatlingVersion((String)Option$.MODULE$.apply((Object)MODULE$.Prefs().get(MODULE$.LatestReleaseNumberPref(), null)).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(11).append(MODULE$.LatestReleaseNumberPref()).append(" is missing").toString());
            }), (ZonedDateTime)Option$.MODULE$.apply((Object)MODULE$.Prefs().get(MODULE$.LatestReleaseDatePref(), null)).map((Function1 & Serializable)x$1 -> ZonedDateTime.parse(x$1, DateTimeFormatter.ISO_DATE_TIME)).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(11).append(MODULE$.LatestReleaseDatePref()).append(" is missing").toString());
            }))) : new LatestGatlingRelease.FetchResult.Failure(lastCheckTimestamp);
        });
    }

    private Try<BoxedUnit> persist(LatestGatlingRelease.FetchResult lastCheck) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.Prefs().putLong(MODULE$.LastCheckTimestampPref(), lastCheck.lastCheckTimestamp());
            LatestGatlingRelease.FetchResult fetchResult = lastCheck;
            if (fetchResult instanceof LatestGatlingRelease.FetchResult.Success) {
                LatestGatlingRelease.FetchResult.Success success = (LatestGatlingRelease.FetchResult.Success)fetchResult;
                GatlingVersion latestRelease = success.latestRelease();
                MODULE$.Prefs().putBoolean(MODULE$.LastCheckSuccessPref(), true);
                MODULE$.Prefs().put(MODULE$.LatestReleaseNumberPref(), latestRelease.fullVersion());
                MODULE$.Prefs().putLong(MODULE$.LastCheckSuccessPref(), latestRelease.releaseDate().toInstant().toEpochMilli());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                MODULE$.Prefs().putBoolean(MODULE$.LastCheckSuccessPref(), false);
                MODULE$.Prefs().remove(MODULE$.LatestReleaseNumberPref());
                MODULE$.Prefs().remove(MODULE$.LastCheckSuccessPref());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            MODULE$.Prefs().flush();
        });
    }

    private Try<GatlingVersion> fetchLatestReleaseFromMavenCentral() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            GatlingVersion gatlingVersion;
            HttpURLConnection conn = (HttpURLConnection)new URL(MODULE$.MavenCentralQuery()).openConnection();
            try {
                conn.setReadTimeout(MODULE$.MavenCentralQueryTimeoutMillis());
                conn.setConnectTimeout(MODULE$.MavenCentralQueryTimeoutMillis());
                conn.setDoInput(true);
                conn.setDoOutput(false);
                conn.setUseCaches(true);
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Connection", "close");
                String response = new String(Io.RichInputStream$.MODULE$.toByteArray$extension(Io$.MODULE$.RichInputStream(conn.getInputStream())), StandardCharsets.UTF_8);
                gatlingVersion = MODULE$.parseMavenCentralResponse(response);
            }
            finally {
                conn.disconnect();
            }
            return gatlingVersion;
        });
    }

    public GatlingVersion parseMavenCentralResponse(String response) {
        String version = ((Regex.MatchData)this.MavenCentralQueryVersionRegex().findFirstMatchIn((CharSequence)response).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(32).append("Failed to find version field in ").append(response).toString());
        })).group(1);
        long timestamp = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((Regex.MatchData)this.MavenCentralQueryTimestampRegex().findFirstMatchIn((CharSequence)response).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(34).append("Failed to find timestamp field in ").append(response).toString());
        })).group(1)));
        return new GatlingVersion(version, ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC));
    }

    private final <T> Try<T> OnFailureTry(Try<T> t) {
        return t;
    }

    public Option<GatlingVersion> load() {
        None$ none$;
        Success success;
        LatestGatlingRelease.FetchResult lastCheck;
        long now = System.currentTimeMillis();
        Try<LatestGatlingRelease.FetchResult> try_ = LatestGatlingRelease$OnFailureTry$.MODULE$.logDebugOnFailure$extension(this.OnFailureTry(this.loadPersisted()), "Failed to load persisted latest release");
        if (try_ instanceof Success && (lastCheck = (LatestGatlingRelease.FetchResult)(success = (Success)try_).value()).valid(now)) {
            None$ none$2;
            LatestGatlingRelease.FetchResult fetchResult = lastCheck;
            if (fetchResult instanceof LatestGatlingRelease.FetchResult.Success) {
                LatestGatlingRelease.FetchResult.Success success2 = (LatestGatlingRelease.FetchResult.Success)fetchResult;
                GatlingVersion latestRelease = success2.latestRelease();
                none$2 = new Some((Object)latestRelease);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else {
            Try<GatlingVersion> maybeFetched = LatestGatlingRelease$OnFailureTry$.MODULE$.logDebugOnFailure$extension(this.OnFailureTry(this.fetchLatestReleaseFromMavenCentral()), "Failed to fetch latest release from maven central");
            LatestGatlingRelease.FetchResult fetchResult = (LatestGatlingRelease.FetchResult)maybeFetched.fold((Function1 & Serializable)x$2 -> new LatestGatlingRelease.FetchResult.Failure(now), (Function1 & Serializable)x$3 -> new LatestGatlingRelease.FetchResult.Success(now, (GatlingVersion)x$3));
            LatestGatlingRelease$OnFailureTry$.MODULE$.logDebugOnFailure$extension(this.OnFailureTry(this.persist(fetchResult)), "Failed to persist last version check");
            none$ = maybeFetched.toOption();
        }
        return none$;
    }

    private LatestGatlingRelease$() {
    }
}

