/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.core.check.CheckBuilder;
import io.gatling.core.check.css.CssCheckBuilder;
import io.gatling.core.check.css.CssCheckType;
import io.gatling.core.check.css.NodeConverter;
import io.gatling.core.check.jmespath.JmesPathCheckBuilder;
import io.gatling.core.check.jmespath.JmesPathCheckType;
import io.gatling.core.check.jmespath.JsonpJmesPathCheckBuilder;
import io.gatling.core.check.jmespath.JsonpJmesPathCheckType;
import io.gatling.core.check.jsonpath.JsonFilter;
import io.gatling.core.check.jsonpath.JsonPathCheckBuilder;
import io.gatling.core.check.jsonpath.JsonPathCheckType;
import io.gatling.core.check.jsonpath.JsonpJsonPathCheckBuilder;
import io.gatling.core.check.jsonpath.JsonpJsonPathCheckType;
import io.gatling.core.check.regex.GroupExtractor;
import io.gatling.core.check.regex.RegexCheckBuilder;
import io.gatling.core.check.regex.RegexCheckType;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Comparisons;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.CoreCheckBuilders;
import io.gatling.javaapi.core.internal.CoreCheckType;
import io.gatling.javaapi.core.internal.Expressions;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeSelector;
import net.jodah.typetools.TypeResolver;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.Tuple7;
import scala.Tuple8;

public interface CheckBuilder {
    public io.gatling.core.check.CheckBuilder<?, ?> asScala();

    public CheckType type();

    public static final class Css
    extends CssOfTypeMultipleFind.Default<CssCheckType> {
        public Css(CheckBuilder.MultipleFind<CssCheckType, NodeSelector, String> multipleFind) {
            super(multipleFind, CoreCheckType.Css);
        }

        @Override
        @Nonnull
        protected <X> CheckBuilder.MultipleFind<CssCheckType, NodeSelector, X> ofType(NodeConverter<X> nodeConverter) {
            CssCheckBuilder cssCheckBuilder = (CssCheckBuilder)this.wrapped;
            return new CssCheckBuilder(cssCheckBuilder.expression(), cssCheckBuilder.nodeAttribute(), cssCheckBuilder.selectors(), nodeConverter);
        }
    }

    public static interface CssOfTypeMultipleFind
    extends MultipleFind<String> {
        @Nonnull
        public MultipleFind<String> ofString();

        @Nonnull
        public MultipleFind<Node> ofNode();

        public static abstract class Default<T>
        extends MultipleFind.Default<T, NodeSelector, String, String>
        implements CssOfTypeMultipleFind {
            public Default(CheckBuilder.MultipleFind<T, NodeSelector, String> multipleFind, CheckType checkType) {
                super(multipleFind, checkType, Function.identity());
            }

            @Nonnull
            protected abstract <X> CheckBuilder.MultipleFind<T, NodeSelector, X> ofType(NodeConverter<X> var1);

            @Override
            @Nonnull
            public MultipleFind<String> ofString() {
                return new MultipleFind.Default(this.ofType(NodeConverter.stringNodeConverter()), this.type, Function.identity());
            }

            @Override
            @Nonnull
            public MultipleFind<Node> ofNode() {
                return new MultipleFind.Default(this.ofType(NodeConverter.nodeNodeConverter()), this.type, Function.identity());
            }
        }
    }

    public static final class JsonpJsonPath
    extends JsonOfTypeMultipleFind.Default<JsonpJsonPathCheckType> {
        public JsonpJsonPath(@Nonnull CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, String> multipleFind) {
            super(multipleFind, CoreCheckType.JsonpJsonPath);
        }

        @Override
        @Nonnull
        protected <X> CheckBuilder.MultipleFind<JsonpJsonPathCheckType, JsonNode, X> ofType(JsonFilter<X> jsonFilter) {
            JsonpJsonPathCheckBuilder jsonpJsonPathCheckBuilder = (JsonpJsonPathCheckBuilder)this.wrapped;
            return new JsonpJsonPathCheckBuilder(jsonpJsonPathCheckBuilder.path(), jsonpJsonPathCheckBuilder.jsonPaths(), jsonFilter);
        }
    }

    public static final class JsonPath
    extends JsonOfTypeMultipleFind.Default<JsonPathCheckType> {
        public JsonPath(@Nonnull CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, String> multipleFind) {
            super(multipleFind, CoreCheckType.JsonPath);
        }

        @Override
        @Nonnull
        protected <X> CheckBuilder.MultipleFind<JsonPathCheckType, JsonNode, X> ofType(JsonFilter<X> jsonFilter) {
            JsonPathCheckBuilder jsonPathCheckBuilder = (JsonPathCheckBuilder)this.wrapped;
            return new JsonPathCheckBuilder(jsonPathCheckBuilder.path(), jsonPathCheckBuilder.jsonPaths(), jsonFilter);
        }
    }

    public static final class JsonpJmesPath
    extends JsonOfTypeFind.Default<JsonpJmesPathCheckType> {
        public JsonpJmesPath(@Nonnull CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, String> find) {
            super(find, CoreCheckType.JsonpJmesPath);
        }

        @Override
        @Nonnull
        protected <X> CheckBuilder.Find<JsonpJmesPathCheckType, JsonNode, X> ofType(JsonFilter<X> jsonFilter) {
            JsonpJmesPathCheckBuilder jsonpJmesPathCheckBuilder = (JsonpJmesPathCheckBuilder)this.wrapped;
            return new JsonpJmesPathCheckBuilder(jsonpJmesPathCheckBuilder.path(), jsonpJmesPathCheckBuilder.jmesPaths(), jsonFilter);
        }
    }

    public static final class JmesPath
    extends JsonOfTypeFind.Default<JmesPathCheckType> {
        public JmesPath(CheckBuilder.Find<JmesPathCheckType, JsonNode, String> find) {
            super(find, CoreCheckType.JmesPath);
        }

        @Override
        @Nonnull
        protected <X> CheckBuilder.Find<JmesPathCheckType, JsonNode, X> ofType(JsonFilter<X> jsonFilter) {
            JmesPathCheckBuilder jmesPathCheckBuilder = (JmesPathCheckBuilder)this.wrapped;
            return new JmesPathCheckBuilder(jmesPathCheckBuilder.path(), jmesPathCheckBuilder.jmesPaths(), jsonFilter);
        }
    }

    public static interface JsonOfTypeMultipleFind
    extends MultipleFind<String> {
        @Nonnull
        public MultipleFind<String> ofString();

        @Nonnull
        public MultipleFind<Boolean> ofBoolean();

        @Nonnull
        public MultipleFind<Integer> ofInt();

        @Nonnull
        public MultipleFind<Long> ofLong();

        @Nonnull
        public MultipleFind<Double> ofDouble();

        @Nonnull
        public MultipleFind<List<Object>> ofList();

        @Nonnull
        public MultipleFind<Map<String, Object>> ofMap();

        @Nonnull
        public MultipleFind<Object> ofObject();

        public static abstract class Default<T>
        extends MultipleFind.Default<T, JsonNode, String, String>
        implements JsonOfTypeMultipleFind {
            public Default(CheckBuilder.MultipleFind<T, JsonNode, String> multipleFind, CheckType checkType) {
                super(multipleFind, checkType, Function.identity());
            }

            @Nonnull
            protected abstract <X> CheckBuilder.MultipleFind<T, JsonNode, X> ofType(JsonFilter<X> var1);

            @Override
            @Nonnull
            public MultipleFind<String> ofString() {
                return new MultipleFind.Default(this.ofType(JsonFilter.stringJsonFilter()), this.type, Function.identity());
            }

            @Override
            @Nonnull
            public MultipleFind<Boolean> ofBoolean() {
                return new MultipleFind.Default<T, JsonNode, Object, Boolean>(this.ofType(JsonFilter.jBooleanJsonFilter()), this.type, Boolean.class::cast);
            }

            @Override
            @Nonnull
            public MultipleFind<Integer> ofInt() {
                return new MultipleFind.Default<T, JsonNode, Object, Integer>(this.ofType(JsonFilter.jIntegerJsonFilter()), this.type, Integer.class::cast);
            }

            @Override
            @Nonnull
            public MultipleFind<Long> ofLong() {
                return new MultipleFind.Default<T, JsonNode, Object, Long>(this.ofType(JsonFilter.jLongJsonFilter()), this.type, Long.class::cast);
            }

            @Override
            @Nonnull
            public MultipleFind<Double> ofDouble() {
                return new MultipleFind.Default<T, JsonNode, Object, Double>(this.ofType(JsonFilter.jDoubleJsonFilter()), this.type, Double.class::cast);
            }

            @Override
            @Nonnull
            public MultipleFind<List<Object>> ofList() {
                return new MultipleFind.Default(this.ofType(JsonFilter.jListJsonFilter()), this.type, Function.identity());
            }

            @Override
            @Nonnull
            public MultipleFind<Map<String, Object>> ofMap() {
                return new MultipleFind.Default(this.ofType(JsonFilter.jMapJsonFilter()), this.type, Function.identity());
            }

            @Override
            @Nonnull
            public MultipleFind<Object> ofObject() {
                return new MultipleFind.Default(this.ofType(JsonFilter.jObjectJsonFilter()), this.type, Function.identity());
            }
        }
    }

    public static interface JsonOfTypeFind
    extends Find<String> {
        @Nonnull
        public Find<String> ofString();

        @Nonnull
        public Find<Boolean> ofBoolean();

        @Nonnull
        public Find<Integer> ofInt();

        @Nonnull
        public Find<Long> ofLong();

        @Nonnull
        public Find<Double> ofDouble();

        @Nonnull
        public Find<List<Object>> ofList();

        @Nonnull
        public Find<Map<String, Object>> ofMap();

        @Nonnull
        public Find<Object> ofObject();

        public static abstract class Default<T>
        extends Find.Default<T, JsonNode, String, String>
        implements JsonOfTypeFind {
            public Default(CheckBuilder.Find<T, JsonNode, String> find, CheckType checkType) {
                super(find, checkType, Function.identity());
            }

            @Nonnull
            protected abstract <X> CheckBuilder.Find<T, JsonNode, X> ofType(JsonFilter<X> var1);

            @Override
            @Nonnull
            public Find<String> ofString() {
                return new Find.Default(this.ofType(JsonFilter.stringJsonFilter()), this.type, Function.identity());
            }

            @Override
            @Nonnull
            public Find<Boolean> ofBoolean() {
                return new Find.Default<T, JsonNode, Object, Boolean>(this.ofType(JsonFilter.jBooleanJsonFilter()), this.type, Boolean.class::cast);
            }

            @Override
            @Nonnull
            public Find<Integer> ofInt() {
                return new Find.Default<T, JsonNode, Object, Integer>(this.ofType(JsonFilter.jIntegerJsonFilter()), this.type, Integer.class::cast);
            }

            @Override
            @Nonnull
            public Find<Long> ofLong() {
                return new Find.Default<T, JsonNode, Object, Long>(this.ofType(JsonFilter.jLongJsonFilter()), this.type, Long.class::cast);
            }

            @Override
            @Nonnull
            public Find<Double> ofDouble() {
                return new Find.Default<T, JsonNode, Object, Double>(this.ofType(JsonFilter.jDoubleJsonFilter()), this.type, Double.class::cast);
            }

            @Override
            @Nonnull
            public Find<List<Object>> ofList() {
                return new Find.Default(this.ofType(JsonFilter.jListJsonFilter()), this.type, Function.identity());
            }

            @Override
            @Nonnull
            public Find<Map<String, Object>> ofMap() {
                return new Find.Default(this.ofType(JsonFilter.jMapJsonFilter()), this.type, Function.identity());
            }

            @Override
            @Nonnull
            public Find<Object> ofObject() {
                return new Find.Default(this.ofType(JsonFilter.jObjectJsonFilter()), this.type, Function.identity());
            }
        }
    }

    public static final class Regex
    extends CaptureGroupCheckBuilder.Default<RegexCheckType, String> {
        public Regex(CheckBuilder.MultipleFind<RegexCheckType, String, String> multipleFind) {
            super(multipleFind, CoreCheckType.Regex);
        }

        @Override
        @Nonnull
        protected <X> CheckBuilder.MultipleFind<RegexCheckType, String, X> extract(@Nonnull GroupExtractor<X> groupExtractor) {
            RegexCheckBuilder regexCheckBuilder = (RegexCheckBuilder)this.wrapped;
            return new RegexCheckBuilder(regexCheckBuilder.pattern(), regexCheckBuilder.patterns(), groupExtractor);
        }
    }

    public static interface CaptureGroupCheckBuilder
    extends MultipleFind<String> {
        @Nonnull
        public MultipleFind<List<String>> captureGroups(int var1);

        public static abstract class Default<T, P>
        extends MultipleFind.Default<T, P, String, String>
        implements CaptureGroupCheckBuilder {
            public Default(CheckBuilder.MultipleFind<T, P, String> multipleFind, CheckType checkType) {
                super(multipleFind, checkType, Function.identity());
            }

            protected abstract <X> CheckBuilder.MultipleFind<T, P, X> extract(GroupExtractor<X> var1);

            @Override
            @Nonnull
            public MultipleFind<List<String>> captureGroups(int n) {
                switch (n) {
                    case 2: {
                        return new MultipleFind.Default<T, P, Tuple2, List>(this.extract(GroupExtractor.groupExtractor2()), this.type, Converters::toJavaList);
                    }
                    case 3: {
                        return new MultipleFind.Default<T, P, Tuple3, List>(this.extract(GroupExtractor.groupExtractor3()), this.type, Converters::toJavaList);
                    }
                    case 4: {
                        return new MultipleFind.Default<T, P, Tuple4, List>(this.extract(GroupExtractor.groupExtractor4()), this.type, Converters::toJavaList);
                    }
                    case 5: {
                        return new MultipleFind.Default<T, P, Tuple5, List>(this.extract(GroupExtractor.groupExtractor5()), this.type, Converters::toJavaList);
                    }
                    case 6: {
                        return new MultipleFind.Default<T, P, Tuple6, List>(this.extract(GroupExtractor.groupExtractor6()), this.type, Converters::toJavaList);
                    }
                    case 7: {
                        return new MultipleFind.Default<T, P, Tuple7, List>(this.extract(GroupExtractor.groupExtractor7()), this.type, Converters::toJavaList);
                    }
                    case 8: {
                        return new MultipleFind.Default<T, P, Tuple8, List>(this.extract(GroupExtractor.groupExtractor8()), this.type, Converters::toJavaList);
                    }
                }
                throw new IllegalArgumentException("captureGroups only supports between 2 and 8 capture groups, included, not " + n);
            }
        }
    }

    public static interface Final
    extends CheckBuilder {
        @Nonnull
        public Final name(@Nonnull String var1);

        @Nonnull
        public Final saveAs(@Nonnull String var1);

        public static final class Default<T, P>
        implements Final {
            private final CheckBuilder.Final<T, P> wrapped;
            private final CheckType type;

            public Default(CheckBuilder.Final<T, P> final_, CheckType checkType) {
                this.wrapped = final_;
                this.type = checkType;
            }

            @Override
            @Nonnull
            public Final name(@Nonnull String string) {
                return new Default<T, P>(this.wrapped.name(string), this.type);
            }

            @Override
            @Nonnull
            public Final saveAs(@Nonnull String string) {
                return new Default<T, P>(this.wrapped.saveAs(string), this.type);
            }

            @Override
            @Nonnull
            public CheckType type() {
                return this.type;
            }

            @Override
            public io.gatling.core.check.CheckBuilder<?, ?> asScala() {
                return this.wrapped;
            }
        }
    }

    public static interface Validate<X>
    extends Final {
        @Nonnull
        public <X2> Validate<X2> transform(@Nonnull Function<X, X2> var1);

        @Nonnull
        public <X2> Validate<X2> transformWithSession(@Nonnull BiFunction<X, Session, X2> var1);

        @Nonnull
        public Validate<X> withDefault(@Nonnull X var1);

        @Nonnull
        public Validate<X> withDefaultEl(@Nonnull String var1);

        @Nonnull
        public Validate<X> withDefault(@Nonnull Function<Session, X> var1);

        @Nonnull
        public Final validate(@Nonnull String var1, @Nonnull BiFunction<X, Session, X> var2);

        @Nonnull
        public Final is(X var1);

        @Nonnull
        default public Final shouldBe(X x) {
            return this.is(x);
        }

        @Nonnull
        public Final isEL(String var1);

        @Nonnull
        public Final is(Function<Session, X> var1);

        @Nonnull
        default public Final shouldBe(Function<Session, X> function) {
            return this.is(function);
        }

        public Final isNull();

        @Nonnull
        public Final not(@Nonnull X var1);

        @Nonnull
        public Final notEL(@Nonnull String var1);

        @Nonnull
        public Final not(@Nonnull Function<Session, X> var1);

        public Final notNull();

        @Nonnull
        public Final in(X ... var1);

        @Nonnull
        default public Final within(X ... XArray) {
            return this.in(XArray);
        }

        @Nonnull
        public Final in(@Nonnull List<X> var1);

        @Nonnull
        default public Final within(@Nonnull List<X> list) {
            return this.in(list);
        }

        @Nonnull
        public Final inEL(@Nonnull String var1);

        @Nonnull
        default public Final withinEL(@Nonnull String string) {
            return this.inEL(string);
        }

        @Nonnull
        public Final in(@Nonnull Function<Session, List<X>> var1);

        @Nonnull
        default public Final within(@Nonnull Function<Session, List<X>> function) {
            return this.in(function);
        }

        @Nonnull
        public Final exists();

        @Nonnull
        public Final notExists();

        @Nonnull
        public Final optional();

        @Nonnull
        public Final lt(@Nonnull X var1);

        @Nonnull
        public Final ltEL(@Nonnull String var1);

        @Nonnull
        public Final lt(@Nonnull Function<Session, X> var1);

        @Nonnull
        public Final lte(@Nonnull X var1);

        @Nonnull
        public Final lteEL(@Nonnull String var1);

        @Nonnull
        public Final lte(@Nonnull Function<Session, X> var1);

        @Nonnull
        public Final gt(@Nonnull X var1);

        @Nonnull
        public Final gtEL(@Nonnull String var1);

        @Nonnull
        public Final gt(@Nonnull Function<Session, X> var1);

        @Nonnull
        public Final gte(@Nonnull X var1);

        @Nonnull
        public Final gteEL(@Nonnull String var1);

        @Nonnull
        public Final gte(@Nonnull Function<Session, X> var1);

        public static final class Default<T, P, X>
        implements Validate<X> {
            private final CheckBuilder.Validate<T, P, X> wrapped;
            private final CheckType type;
            private final Class<?> xClass;

            public Default(CheckBuilder.Validate<T, P, X> validate, CheckType checkType, Class<?> clazz) {
                this.wrapped = validate;
                this.type = checkType;
                this.xClass = clazz;
            }

            private Final makeFinal(CheckBuilder.Final<T, P> final_) {
                return new Final.Default<T, P>(final_, this.type);
            }

            @Override
            @Nonnull
            public <X2> Validate<X2> transform(@Nonnull Function<X, X2> function) {
                Class clazz = TypeResolver.resolveRawArguments(Function.class, function.getClass())[1];
                return new Default<T, P, X>(this.wrapped.transformOption(option -> {
                    Object object = option.isDefined() ? option.get() : null;
                    return Expressions.validation(() -> Option.apply(function.apply(object)));
                }), this.type, clazz);
            }

            @Override
            @Nonnull
            public <X2> Validate<X2> transformWithSession(@Nonnull BiFunction<X, Session, X2> biFunction) {
                Class clazz = TypeResolver.resolveRawArguments(BiFunction.class, biFunction.getClass())[2];
                return new Default<T, P, X>(this.wrapped.transformOptionWithSession((option, session) -> {
                    Object object = option.isDefined() ? option.get() : null;
                    return Expressions.validation(() -> Option.apply(biFunction.apply(object, new Session((io.gatling.core.session.Session)session))));
                }), this.type, clazz);
            }

            @Override
            @Nonnull
            public Validate<X> withDefault(@Nonnull X x) {
                return new Default<T, P, X>(this.wrapped.withDefault(Expressions.toStaticValueExpression(x)), this.type, this.xClass);
            }

            @Override
            @Nonnull
            public Validate<X> withDefaultEl(@Nonnull String string) {
                return new Default<T, P, X>(this.wrapped.withDefault(Expressions.toExpression(string, this.xClass)), this.type, this.xClass);
            }

            @Override
            @Nonnull
            public Validate<X> withDefault(@Nonnull Function<Session, X> function) {
                return new Default<T, P, X>(this.wrapped.withDefault(Expressions.javaFunctionToExpression(function)), this.type, this.xClass);
            }

            @Override
            @Nonnull
            public Final is(@Nonnull X x) {
                return this.makeFinal(this.wrapped.is(Expressions.toStaticValueExpression(x), Comparisons.equality(this.xClass)));
            }

            @Override
            @Nonnull
            public Final validate(@Nonnull String string, @Nonnull BiFunction<X, Session, X> biFunction) {
                return this.makeFinal(this.wrapped.validate(string, (option, session) -> {
                    Object object = option.isDefined() ? option.get() : null;
                    return Expressions.validation(() -> Option.apply(biFunction.apply(object, new Session((io.gatling.core.session.Session)session))));
                }));
            }

            @Override
            @Nonnull
            public Final isEL(@Nonnull String string) {
                return this.makeFinal(this.wrapped.is(Expressions.toExpression(string, this.xClass), Comparisons.equality(this.xClass)));
            }

            @Override
            @Nonnull
            public Final is(@Nonnull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.is(Expressions.javaFunctionToExpression(function), Comparisons.equality(this.xClass)));
            }

            @Override
            @Nonnull
            public Final isNull() {
                return this.makeFinal(this.wrapped.isNull());
            }

            @Override
            @Nonnull
            public Final not(@Nonnull X x) {
                return this.makeFinal(this.wrapped.not(Expressions.toStaticValueExpression(x), Comparisons.equality(this.xClass)));
            }

            @Override
            @Nonnull
            public Final notEL(@Nonnull String string) {
                return this.makeFinal(this.wrapped.not(Expressions.toExpression(string, this.xClass), Comparisons.equality(this.xClass)));
            }

            @Override
            @Nonnull
            public Final not(@Nonnull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.not(Expressions.javaFunctionToExpression(function), Comparisons.equality(this.xClass)));
            }

            @Override
            @Nonnull
            public Final notNull() {
                return this.makeFinal(this.wrapped.notNull());
            }

            @Override
            @Nonnull
            public Final in(X ... XArray) {
                return this.makeFinal(this.wrapped.in(Converters.toScalaSeq(XArray)));
            }

            @Override
            @Nonnull
            public Final in(@Nonnull List<X> list) {
                return this.makeFinal(this.wrapped.in(Converters.toScalaSeq(list)));
            }

            @Override
            @Nonnull
            public Final inEL(@Nonnull String string) {
                return this.makeFinal(this.wrapped.in(Expressions.toSeqExpression(string)));
            }

            @Override
            @Nonnull
            public Final in(@Nonnull Function<Session, List<X>> function) {
                return this.makeFinal(this.wrapped.in(Expressions.javaListFunctionToImmutableSeqExpression(function)));
            }

            @Override
            @Nonnull
            public Final exists() {
                return this.makeFinal(this.wrapped.exists());
            }

            @Override
            @Nonnull
            public Final notExists() {
                return this.makeFinal(this.wrapped.notExists());
            }

            @Override
            @Nonnull
            public Final optional() {
                return this.makeFinal(this.wrapped.optional());
            }

            @Override
            @Nonnull
            public Final lt(@Nonnull X x) {
                return this.makeFinal(this.wrapped.lt(Expressions.toStaticValueExpression(x), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final ltEL(@Nonnull String string) {
                return this.makeFinal(this.wrapped.lt(Expressions.toExpression(string, this.xClass), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final lt(@Nonnull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.lt(Expressions.javaFunctionToExpression(function), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final lte(@Nonnull X x) {
                return this.makeFinal(this.wrapped.lte(Expressions.toStaticValueExpression(x), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final lteEL(@Nonnull String string) {
                return this.makeFinal(this.wrapped.lte(Expressions.toExpression(string, this.xClass), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final lte(@Nonnull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.lte(Expressions.javaFunctionToExpression(function), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final gt(@Nonnull X x) {
                return this.makeFinal(this.wrapped.gt(Expressions.toStaticValueExpression(x), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final gtEL(@Nonnull String string) {
                return this.makeFinal(this.wrapped.gt(Expressions.toExpression(string, this.xClass), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final gt(@Nonnull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.gt(Expressions.javaFunctionToExpression(function), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final gte(@Nonnull X x) {
                return this.makeFinal(this.wrapped.gte(Expressions.toStaticValueExpression(x), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final gteEL(@Nonnull String string) {
                return this.makeFinal(this.wrapped.gte(Expressions.toExpression(string, this.xClass), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final gte(@Nonnull Function<Session, X> function) {
                return this.makeFinal(this.wrapped.gte(Expressions.javaFunctionToExpression(function), Comparisons.ordering(this.xClass)));
            }

            @Override
            @Nonnull
            public Final name(@Nonnull String string) {
                return this.exists().name(string);
            }

            @Override
            @Nonnull
            public Final saveAs(@Nonnull String string) {
                return this.exists().saveAs(string);
            }

            @Override
            @Nonnull
            public CheckType type() {
                return this.exists().type();
            }

            @Override
            public io.gatling.core.check.CheckBuilder<?, ?> asScala() {
                return this.exists().asScala();
            }
        }
    }

    public static interface MultipleFind<JavaX>
    extends Find<JavaX> {
        @Nonnull
        public Validate<JavaX> find(int var1);

        @Nonnull
        public Validate<List<JavaX>> findAll();

        @Nonnull
        public Validate<JavaX> findRandom();

        @Nonnull
        public Validate<List<JavaX>> findRandom(int var1);

        @Nonnull
        public Validate<List<JavaX>> findRandom(int var1, boolean var2);

        @Nonnull
        public Validate<Integer> count();

        public static class Default<T, P, ScalaX, JavaX>
        extends Find.Default<T, P, ScalaX, JavaX>
        implements MultipleFind<JavaX> {
            protected final CheckBuilder.MultipleFind<T, P, ScalaX> wrapped;

            public Default(@Nonnull CheckBuilder.MultipleFind<T, P, ScalaX> multipleFind, @Nonnull CheckType checkType, @Nonnull Function<ScalaX, JavaX> function) {
                super(multipleFind, checkType, function);
                this.wrapped = multipleFind;
            }

            private <X2> Validate<X2> makeValidate(CheckBuilder.Validate<T, P, X2> validate) {
                return new Validate.Default<T, P, X2>(validate, this.type, this.javaXClass);
            }

            @Override
            @Nonnull
            public Validate<JavaX> find() {
                return this.makeValidate(CoreCheckBuilders.transformSingleCheck(this.wrapped.find(), this.scalaXToJavaX));
            }

            @Override
            @Nonnull
            public Validate<JavaX> find(int n) {
                return this.makeValidate(CoreCheckBuilders.transformSingleCheck(this.wrapped.find(n), this.scalaXToJavaX));
            }

            @Override
            @Nonnull
            public Validate<List<JavaX>> findAll() {
                return this.makeValidate(CoreCheckBuilders.transformSeqCheck(this.wrapped.findAll(), this.scalaXToJavaX));
            }

            @Override
            @Nonnull
            public Validate<JavaX> findRandom() {
                return this.makeValidate(CoreCheckBuilders.transformSingleCheck(this.wrapped.findRandom(), this.scalaXToJavaX));
            }

            @Override
            @Nonnull
            public Validate<List<JavaX>> findRandom(int n) {
                return this.findRandom(n, false);
            }

            @Override
            @Nonnull
            public Validate<List<JavaX>> findRandom(int n, boolean bl) {
                return this.makeValidate(CoreCheckBuilders.transformSeqCheck(this.wrapped.findRandom(n, bl), this.scalaXToJavaX));
            }

            @Override
            @Nonnull
            public Validate<Integer> count() {
                return this.makeValidate(CoreCheckBuilders.toCountCheck(this.wrapped));
            }
        }
    }

    public static interface Find<JavaX>
    extends Validate<JavaX> {
        public Validate<JavaX> find();

        public static class Default<T, P, ScalaX, JavaX>
        implements Find<JavaX> {
            protected final CheckBuilder.Find<T, P, ScalaX> wrapped;
            protected final CheckType type;
            protected final Class<?> javaXClass;
            protected final Function<ScalaX, JavaX> scalaXToJavaX;

            public Default(CheckBuilder.Find<T, P, ScalaX> find, CheckType checkType, Function<ScalaX, JavaX> function) {
                this.wrapped = find;
                this.type = checkType;
                this.javaXClass = TypeResolver.resolveRawArguments(Function.class, function.getClass())[1];
                this.scalaXToJavaX = function;
            }

            @Override
            @Nonnull
            public Validate<JavaX> find() {
                return new Validate.Default(this.wrapped.find().transform(Converters.toScalaFunction(this.scalaXToJavaX)), this.type, this.javaXClass);
            }

            @Override
            @Nonnull
            public <X2> Validate<X2> transform(@Nonnull Function<JavaX, X2> function) {
                return this.find().transform(function);
            }

            @Override
            @Nonnull
            public <X2> Validate<X2> transformWithSession(@Nonnull BiFunction<JavaX, Session, X2> biFunction) {
                return this.find().transformWithSession(biFunction);
            }

            @Override
            @Nonnull
            public Validate<JavaX> withDefault(@Nonnull JavaX JavaX) {
                return this.find().withDefault(JavaX);
            }

            @Override
            @Nonnull
            public Validate<JavaX> withDefaultEl(@Nonnull String string) {
                return this.find().withDefaultEl(string);
            }

            @Override
            @Nonnull
            public Validate<JavaX> withDefault(@Nonnull Function<Session, JavaX> function) {
                return this.find().withDefault(function);
            }

            @Override
            @Nonnull
            public Final validate(@Nonnull String string, @Nonnull BiFunction<JavaX, Session, JavaX> biFunction) {
                return this.find().validate(string, biFunction);
            }

            @Override
            @Nonnull
            public Final isEL(@Nonnull String string) {
                return this.find().isEL(string);
            }

            @Override
            @Nonnull
            public Final is(@Nonnull JavaX JavaX) {
                return this.find().is(JavaX);
            }

            @Override
            @Nonnull
            public Final is(@Nonnull Function<Session, JavaX> function) {
                return this.find().is(function);
            }

            @Override
            @Nonnull
            public Final isNull() {
                return this.find().isNull();
            }

            @Override
            @Nonnull
            public Final notEL(@Nonnull String string) {
                return this.find().notEL(string);
            }

            @Override
            @Nonnull
            public Final not(@Nonnull JavaX JavaX) {
                return this.find().not(JavaX);
            }

            @Override
            @Nonnull
            public Final not(@Nonnull Function<Session, JavaX> function) {
                return this.find().not(function);
            }

            @Override
            @Nonnull
            public Final notNull() {
                return this.find().notNull();
            }

            @Override
            @Nonnull
            public Final in(JavaX ... JavaXArray) {
                return this.find().in(JavaXArray);
            }

            @Override
            @Nonnull
            public Final in(@Nonnull List<JavaX> list) {
                return this.find().in(list);
            }

            @Override
            @Nonnull
            public Final inEL(@Nonnull String string) {
                return this.find().inEL(string);
            }

            @Override
            @Nonnull
            public Final in(@Nonnull Function<Session, List<JavaX>> function) {
                return this.find().in(function);
            }

            @Override
            @Nonnull
            public Final exists() {
                return this.find().exists();
            }

            @Override
            @Nonnull
            public Final notExists() {
                return this.find().notExists();
            }

            @Override
            @Nonnull
            public Final optional() {
                return this.find().optional();
            }

            @Override
            @Nonnull
            public Final lt(@Nonnull JavaX JavaX) {
                return this.find().lt(JavaX);
            }

            @Override
            @Nonnull
            public Final ltEL(@Nonnull String string) {
                return this.find().ltEL(string);
            }

            @Override
            @Nonnull
            public Final lt(@Nonnull Function<Session, JavaX> function) {
                return this.find().lt(function);
            }

            @Override
            @Nonnull
            public Final lte(@Nonnull JavaX JavaX) {
                return this.find().lte(JavaX);
            }

            @Override
            @Nonnull
            public Final lteEL(@Nonnull String string) {
                return this.find().lteEL(string);
            }

            @Override
            @Nonnull
            public Final lte(@Nonnull Function<Session, JavaX> function) {
                return this.find().lte(function);
            }

            @Override
            @Nonnull
            public Final gt(@Nonnull JavaX JavaX) {
                return this.find().gt(JavaX);
            }

            @Override
            @Nonnull
            public Final gtEL(@Nonnull String string) {
                return this.find().gtEL(string);
            }

            @Override
            @Nonnull
            public Final gt(@Nonnull Function<Session, JavaX> function) {
                return this.find().gt(function);
            }

            @Override
            @Nonnull
            public Final gte(@Nonnull JavaX JavaX) {
                return this.find().gte(JavaX);
            }

            @Override
            @Nonnull
            public Final gteEL(@Nonnull String string) {
                return this.find().gteEL(string);
            }

            @Override
            @Nonnull
            public Final gte(@Nonnull Function<Session, JavaX> function) {
                return this.find().gte(function);
            }

            @Override
            @Nonnull
            public Final name(@Nonnull String string) {
                return this.find().name(string);
            }

            @Override
            @Nonnull
            public Final saveAs(@Nonnull String string) {
                return this.find().saveAs(string);
            }

            @Override
            @Nonnull
            public CheckType type() {
                return this.find().type();
            }

            @Override
            public io.gatling.core.check.CheckBuilder<?, ?> asScala() {
                return this.find().asScala();
            }
        }
    }

    public static interface CheckType {
    }
}

