/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.config;

import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.util.UriHelper$;
import io.gatling.core.util.UriHelper$RichUri$;
import java.io.File;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.io.Path;
import scala.tools.nsc.io.package$;
import scala.util.Properties$;

public final class GatlingFiles$ {
    public static final GatlingFiles$ MODULE$;
    private final URI GatlingHome;
    private final String GatlingAssetsPackage;
    private final String GatlingJsFolder;
    private final String GatlingStyleFolder;
    private final Path GatlingAssetsJsPackage;
    private final Path GatlingAssetsStylePackage;

    static {
        new GatlingFiles$();
    }

    public URI GatlingHome() {
        return this.GatlingHome;
    }

    public String GatlingAssetsPackage() {
        return this.GatlingAssetsPackage;
    }

    public String GatlingJsFolder() {
        return this.GatlingJsFolder;
    }

    public String GatlingStyleFolder() {
        return this.GatlingStyleFolder;
    }

    public Path GatlingAssetsJsPackage() {
        return this.GatlingAssetsJsPackage;
    }

    public Path GatlingAssetsStylePackage() {
        return this.GatlingAssetsStylePackage;
    }

    private URI resolvePath(String path) {
        Path rawPath = package$.MODULE$.Path().apply(path);
        return rawPath.isAbsolute() || rawPath.exists() ? package$.MODULE$.Path().string2path(path).toURI() : UriHelper$RichUri$.MODULE$.$div$extension0(UriHelper$.MODULE$.RichUri(this.GatlingHome()), path);
    }

    public URI dataDirectory() {
        return this.resolvePath(GatlingConfiguration$.MODULE$.configuration().core().directory().data());
    }

    public URI requestBodiesDirectory() {
        return this.resolvePath(GatlingConfiguration$.MODULE$.configuration().core().directory().requestBodies());
    }

    public URI sourcesDirectory() {
        return this.resolvePath(GatlingConfiguration$.MODULE$.configuration().core().directory().sources());
    }

    public Option<String> reportsOnlyDirectory() {
        return GatlingConfiguration$.MODULE$.configuration().core().directory().reportsOnly();
    }

    public Option<URI> binariesDirectory() {
        return GatlingConfiguration$.MODULE$.configuration().core().directory().binaries().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URI apply(String x$1) {
                return new File(x$1).toURI();
            }
        });
    }

    public URI resultDirectory(String runUuid) {
        return this.resolvePath(new StringBuilder().append((Object)GatlingConfiguration$.MODULE$.configuration().core().directory().results()).append((Object)"/").append((Object)runUuid).toString());
    }

    public URI jsDirectory(String runUuid) {
        return UriHelper$RichUri$.MODULE$.$div$extension0(UriHelper$.MODULE$.RichUri(this.resultDirectory(runUuid)), this.GatlingJsFolder());
    }

    public URI styleDirectory(String runUuid) {
        return UriHelper$RichUri$.MODULE$.$div$extension0(UriHelper$.MODULE$.RichUri(this.resultDirectory(runUuid)), this.GatlingStyleFolder());
    }

    public URI simulationLogDirectory(String runUuid, boolean create) {
        URI uRI;
        URI dir = this.resultDirectory(runUuid);
        if (create) {
            UriHelper$RichUri$.MODULE$.toFile$extension(UriHelper$.MODULE$.RichUri(dir)).mkdirs();
            uRI = this.resultDirectory(runUuid);
        } else {
            Predef$.MODULE$.require(UriHelper$RichUri$.MODULE$.toFile$extension(UriHelper$.MODULE$.RichUri(dir)).exists(), (Function0)new Serializable(dir){
                public static final long serialVersionUID = 0L;
                private final URI dir$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"simulation directory '", "' doesn't exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir$1}));
                }
                {
                    this.dir$1 = dir$1;
                }
            });
            Predef$.MODULE$.require(UriHelper$RichUri$.MODULE$.toFile$extension(UriHelper$.MODULE$.RichUri(dir)).isDirectory(), (Function0)new Serializable(dir){
                public static final long serialVersionUID = 0L;
                private final URI dir$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"simulation directory '", "' is not a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir$1}));
                }
                {
                    this.dir$1 = dir$1;
                }
            });
            uRI = dir;
        }
        return uRI;
    }

    public boolean simulationLogDirectory$default$2() {
        return true;
    }

    private GatlingFiles$() {
        MODULE$ = this;
        this.GatlingHome = UriHelper$.MODULE$.pathToUri(Properties$.MODULE$.envOrElse("GATLING_HOME", Properties$.MODULE$.propOrElse("GATLING_HOME", ".")));
        this.GatlingAssetsPackage = "assets";
        this.GatlingJsFolder = "js";
        this.GatlingStyleFolder = "style";
        this.GatlingAssetsJsPackage = package$.MODULE$.Path().string2path(this.GatlingAssetsPackage()).$div(package$.MODULE$.Path().string2path(this.GatlingJsFolder()));
        this.GatlingAssetsStylePackage = package$.MODULE$.Path().string2path(this.GatlingAssetsPackage()).$div(package$.MODULE$.Path().string2path(this.GatlingStyleFolder()));
    }
}

