/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.runner;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Scheduler;
import akka.pattern.AskSupport;
import akka.util.Timeout;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.core.akka.AkkaDefaults;
import io.gatling.core.akka.AkkaDefaults$class;
import io.gatling.core.akka.GatlingActorSystem$;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.Run;
import io.gatling.core.runner.Selection;
import io.gatling.core.scenario.Simulation;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001\u0017\t1!+\u001e8oKJT!a\u0001\u0003\u0002\rI,hN\\3s\u0015\t)a!\u0001\u0003d_J,'BA\u0004\t\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!C\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001\u0019IA\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005!\u0011m[6b\u0013\t9BC\u0001\u0007BW.\fG)\u001a4bk2$8\u000f\u0005\u0002\u001aE5\t!D\u0003\u0002\u001c9\u0005)1\u000f\u001c45U*\u0011QDH\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003?\u0001\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002C\u0005\u00191m\\7\n\u0005\rR\"!D*ue&\u001cG\u000fT8hO&tw\r\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003%\u0019X\r\\3di&|g\u000e\u0005\u0002(Q5\t!!\u0003\u0002*\u0005\tI1+\u001a7fGRLwN\u001c\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055r\u0003CA\u0014\u0001\u0011\u0015)#\u00061\u0001'\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003\r\u0011XO\\\u000b\u0002eA!QbM\u001b=\u0013\t!dB\u0001\u0004UkBdWM\r\t\u0003mer!!D\u001c\n\u0005ar\u0011A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\b\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\"\u0011\u0001C:dK:\f'/[8\n\u0005\u0005s$AC*j[Vd\u0017\r^5p]\u0002")
public class Runner
implements AkkaDefaults,
StrictLogging {
    private final Selection selection;
    private final Logger logger;
    private final FiniteDuration simulationTimeOut;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public FiniteDuration simulationTimeOut() {
        return this.simulationTimeOut;
    }

    @Override
    public void io$gatling$core$akka$AkkaDefaults$_setter_$simulationTimeOut_$eq(FiniteDuration x$1) {
        this.simulationTimeOut = x$1;
    }

    @Override
    public ActorSystem system() {
        return AkkaDefaults$class.system(this);
    }

    @Override
    public ExecutionContextExecutor dispatcher() {
        return AkkaDefaults$class.dispatcher(this);
    }

    @Override
    public Scheduler scheduler() {
        return AkkaDefaults$class.scheduler(this);
    }

    public ActorRef ask(ActorRef actorRef) {
        return AskSupport.class.ask((AskSupport)this, (ActorRef)actorRef);
    }

    public Future<Object> ask(ActorRef actorRef, Object message, Timeout timeout) {
        return AskSupport.class.ask((AskSupport)this, (ActorRef)actorRef, (Object)message, (Timeout)timeout);
    }

    public ActorSelection ask(ActorSelection actorSelection) {
        return AskSupport.class.ask((AskSupport)this, (ActorSelection)actorSelection);
    }

    public Future<Object> ask(ActorSelection actorSelection, Object message, Timeout timeout) {
        return AskSupport.class.ask((AskSupport)this, (ActorSelection)actorSelection, (Object)message, (Timeout)timeout);
    }

    public Tuple2<String, Simulation> run() {
        try {
            Success success;
            Object runId;
            Class<Simulation> simulationClass = this.selection.simulationClass();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Simulation ", " started..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{simulationClass.getName()})));
            GatlingActorSystem$.MODULE$.start();
            Simulation simulation = simulationClass.newInstance();
            System.gc();
            System.gc();
            System.gc();
            Controller$.MODULE$.start();
            simulation._beforeSteps().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Function0<BoxedUnit> x$1) {
                    x$1.apply$mcV$sp();
                }
            });
            Timeout timeOut = new Timeout(this.simulationTimeOut());
            Future<Object> runResult = Controller$.MODULE$.$qmark(new Run(simulation, this.selection.simulationId(), this.selection.description(), simulation.timings()), timeOut);
            Object object = Await$.MODULE$.result(runResult, (Duration)this.simulationTimeOut());
            if (object instanceof Success && (runId = (success = (Success)object).value()) instanceof String) {
                String string = (String)runId;
                Predef$.MODULE$.println((Object)"Simulation finished");
                simulation._afterSteps().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Function0<BoxedUnit> x$2) {
                        x$2.apply$mcV$sp();
                    }
                });
                Tuple2 tuple2 = new Tuple2((Object)string, (Object)simulation);
                return tuple2;
            }
            if (object instanceof Failure) {
                Failure failure = (Failure)object;
                Throwable t = failure.exception();
                throw t;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller replied an unexpected message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
        }
        finally {
            GatlingActorSystem$.MODULE$.shutdown();
        }
    }

    public Runner(Selection selection) {
        this.selection = selection;
        AskSupport.class.$init$((AskSupport)this);
        AkkaDefaults$class.$init$(this);
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

